#include "mbed.h"

/*
    Benchmark test script
*/

///////////////////////////////////////////////////
#define lOOPMACRO(label,symbol) t.reset();\
    t.start();\
    for(i=0;i<REPEAT;i++){\
        (label##_z) = (label##_y) symbol (label##_x);\
    }\
    (label##_result) = t.read_us();\
    t.stop();\
    pc.printf( #label ": %d us ",(label##_result)-overhead);\
    pc.printf("(%f us)\n",(float)((label##_result)-overhead) / (float)REPEAT);

///////////////////////////////////////////////////

const uint32_t REPEAT = 1000000;

Serial pc(USBTX,USBRX);
Timer t;

volatile int8_t i8_x = 12;
volatile int8_t i8_y = 34;
volatile int8_t i8_z;

volatile int16_t i16_x = 12;
volatile int16_t i16_y = 34;
volatile int16_t i16_z;

volatile int32_t i32_x = 12345;
volatile int32_t i32_y = 67890;
volatile int32_t i32_z;

volatile int64_t i64_x = 123456;
volatile int64_t i64_y = 789011;
volatile int64_t i64_z;

volatile float f_x = 1.234567;
volatile float f_y = 2.345678;
volatile float f_z;

volatile double d_x = 1.23456789;
volatile double d_y = 2.34567890;
volatile double d_z;

int main() {
    uint32_t i,overhead,i8_result,i16_result,i32_result,i64_result,f_result,d_result;
    pc.printf("\n\nBenchMark TEST START\n\n  // All calcurates repeat %d times\n\n",REPEAT);
    
    // overhead
    t.reset();
    t.start();
    for(i=0;i<REPEAT;i++){
    }
    overhead = t.read_us();
    t.stop();
    pc.printf("Overhead: %d us\n",overhead);
    
    pc.printf("\nADD\n\n");
    
    lOOPMACRO(i8,+);
    lOOPMACRO(i16,+);
    lOOPMACRO(i32,+);
    lOOPMACRO(i64,+);
    lOOPMACRO(f,+);
    lOOPMACRO(d,+);
    
    pc.printf("\nSUB\n\n");
    
    lOOPMACRO(i8,-);
    lOOPMACRO(i16,-);
    lOOPMACRO(i32,-);
    lOOPMACRO(i64,-);
    lOOPMACRO(f,-);
    lOOPMACRO(d,-);
    
    pc.printf("\nMULTI\n\n");
    
    lOOPMACRO(i8,*);
    lOOPMACRO(i16,*);
    lOOPMACRO(i32,*);
    lOOPMACRO(i64,*);
    lOOPMACRO(f,*);
    lOOPMACRO(d,*);
    
    pc.printf("\nDIV\n\n");
    
    lOOPMACRO(i8,/);
    lOOPMACRO(i16,/);
    lOOPMACRO(i32,/);
    lOOPMACRO(i64,/);
    lOOPMACRO(f,/);
    lOOPMACRO(d,/);
    
    pc.printf("\nDONE\n");
}
