#ifndef _YO_API_H_
#define _YO_API_H_

#include "HTTPClient.h"

/** YoApi Library for mbed
 *  Copyright (c) 2014, Takuya Urakawa
 * 
 *  This library is released under the MIT License
 *  See http://opensource.org/licenses/mit-license.php
 */

/** YoApi class
 *  
 *  Send Yo from mbed
 */

class YoApi {
public:

/** Constructor
 *  
 * @param _http     pointer to HTTPClient
 * @param _apiToken Your Yo ApiToken
 */
    YoApi(HTTPClient& _http, const char* _apiToken)
    : mHttp(_http), mApiToken(_apiToken), API_URI("http://api.justyo.co/yoall/")
    {
    }

/** send YO
 *
 * @return (int)0 on HTTP POST successed 
 */    
    HTTPResult send(void){
        char returnStr[128];
        HTTPMap map;
        HTTPText inText(returnStr, 128);
        map.put("api_token", mApiToken);
        return mHttp.post(API_URI, map, &inText);
    }
    
    
private:
    HTTPClient& mHttp;
    const char* mApiToken;
    const char* API_URI;
};

#endif
