/**
 *  USB COPY&PASTE Keyboard
 *
 *  This is a USB keyboard device for copy&paste freak.
 *  http://www.dm9records.com/index.php?cID=144
 *
 *  @author hsgw(http://twitter.com/hsgw)
 *  @since  2014/12/08
 */

#include "mbed.h"
#include "USBKeyboard.h"
#include "PinDetect.h"

// SW Pin Setting
#define SW_SELECT_ALL  D2
#define SW_COPY        D3
#define SW_PASTE       D4

USBKeyboard keyboard;

PinDetect swSelectAll(SW_SELECT_ALL);
PinDetect swCopy(SW_COPY);
PinDetect swPaste(SW_PASTE);

DigitalOut ledSelectAll(LED_RED);
DigitalOut ledCopy(LED_GREEN);
DigitalOut ledPaste(LED_BLUE);

bool selectSwState = false;
bool copySwState = false;
bool pasteSwState = false;

unsigned int pressedSelectCount = 0;
unsigned int pressedCopyCount = 0;
unsigned int pressedPasteCount = 0;

// callback for pressed sw
void pressedSelectAll()
{
    ledSelectAll = 0;
    selectSwState = true;
}

void pressedCopy()
{
    ledCopy = 0;
    copySwState = true;
}

void pressedPaste()
{
    ledPaste = 0;
    pasteSwState = true;
}

int main(void)
{
    // leds off
    ledSelectAll = 1;
    ledCopy = 1;
    ledPaste = 1;

    // set pin mode to internal PullUp
    swSelectAll.mode(PullUp);
    swCopy.mode(PullUp);
    swPaste.mode(PullUp);

    // attach callback when sw pressed(detecting change of state 1->0)
    swSelectAll.attach_deasserted(&pressedSelectAll);
    swCopy.attach_deasserted(&pressedCopy);
    swPaste.attach_deasserted(&pressedPaste);

    // begin sampling switches
    swSelectAll.setSampleFrequency();
    swCopy.setSampleFrequency();
    swPaste.setSampleFrequency();

    printf("USB COPY&PASTE Keyboard start!\n");
    while(1) {
        if(selectSwState) {
            pressedSelectCount++;
            printf("pressed select: %dtimes\n",pressedSelectCount);
            keyboard.keyCode('a', KEY_CTRL);    // send ctrl+a
            selectSwState = false;
            ledSelectAll = 1;
        }
        if(copySwState) {
            pressedCopyCount++;
            printf("pressed copy: %dtimes\n",pressedCopyCount);
            keyboard.keyCode('c', KEY_CTRL);    // send ctrl+c
            copySwState = false;
            ledCopy = 1;
        }
        if(pasteSwState) {
            pressedPasteCount++;
            printf("pressed paste: %dtimes\n",pressedPasteCount);
            keyboard.keyCode('v', KEY_CTRL);    // send ctrl+v
            pasteSwState = false;
            ledPaste = 1;
        }
    }
}