/** YoApi Example
 *  Copyright (c) 2014, Takuya Urakawa
 *  
 *  Send Yo from mbed.
 *  You can get your Yo API token from https://medium.com/@YoAppStatus/yo-developers-api-e7f2f0ec5c3c
*/

#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "YoApi.h"

const char* apiToken = "YOUR_API_TOKEN";

EthernetInterface eth;
HTTPClient http;
YoApi yo(http,apiToken);

int main() {
    printf("Yo from mbed\n");
    printf("Ethernet initializing\n");
    eth.init();
    eth.connect();
    
    //Yo!
    int ret = yo.send();
    if(!ret) {
      printf("YO!\n");
    }else{
        printf("Error - ret = %d\n", ret);
    }
    
    printf("Disconnect Ethernet\n");
    eth.disconnect();  
    
    return 0;
}