#define _USB_TEST
#include "mbed.h"
#include "USBHostMIDI.h"

DigitalOut led(LED1);
Serial midiOut(PC_6,PA_12);
 
void noteOn(unsigned char channel, unsigned char note, unsigned char velocity) {
    led = 1;
    //printf("note on channel: %d, note: %d, velocity: %d\r\n", channel, note, velocity);
    printf("on\n");
    midiOut.putc(0x90); // status:ch0,noteon
    midiOut.putc(note); // data:noteNo
    midiOut.putc(velocity);// data: velocity
}

void noteOff(unsigned char channel, unsigned char note, unsigned char velocity) {
    led = 0;
    //printf("note off channel: %d, note: %d, velocity: %d\r\n", channel, note, velocity);
    printf("off\n");
    midiOut.putc(0x80); // status:ch0,noteoff
    midiOut.putc(note); // data:noteNo
    midiOut.putc(velocity);// data: velocity
}

//void controlChange(unsigned char channel, unsigned char key, unsigned char value) {
//    printf("control change channel: %d, key: %d, value: %d\r\n", channel, key, value);
//}
//
//void programChange(unsigned char channel, unsigned char program) {
//    printf("progaram change channel: %d, program: %d\r\n", channel, program);
//}
//
//void pitchBend(unsigned char channel, unsigned int value) {
//    printf("pitch bend channel: %d, value: %d\r\n", channel, value);
//}
 
int main() {
    led = 1;
    USBHostMIDI usbmidi; 
    midiOut.baud(31250);
    
    // attach midi event callbacks
    usbmidi.attachNoteOn(noteOn);
    usbmidi.attachNoteOff(noteOff);
    //usbmidi.attachControlChange(controlChange);
    //usbmidi.attachProgramChange(programChange);
    //usbmidi.attachPitchBend(pitchBend);

    while(1) {
        // try to connect a midi device
        while(!usbmidi.connect()) {
            wait_ms(500);
            led = 0;
        }
        
        led = 1;
        wait_ms(200);
        led = 0;
        wait_ms(200);
        led = 1;
        wait_ms(200);
        led = 0;
        wait_ms(200);
        led = 1;
        wait_ms(200);
        led = 0;
        
        // if the device is disconnected, we try to connect it again
        while (1) {
            // if device disconnected, try to connect it again
            if (!usbmidi.connected()) break;
            
            // polling USB task
            USBHost::poll();
        }
        printf("end\n");
    }
}