// sw - p30
// servo control - p25

#include "mbed.h"
#include "rtos.h"
#include "USBMouse.h"
#include "PinDetect.h"
#include "Servo.h"

Serial pc(USBTX, USBRX);
USBMouse mouse;

PinDetect sw(p30);

DigitalOut ledEnable(LED1);
DigitalOut ledClick(LED2);
DigitalOut ledClickContinue(LED3);
DigitalOut ledMbedAlive(LED4);

volatile uint32_t clickCount;
volatile bool clickEnable;

Mutex printMutex;

//servo Thread
void servoMove(void const *arg){
    Servo servo(p25);
    servo = 0.5;
    while(true){
        if(clickEnable && clickCount > 0){
            ledClick = 1;
            servo = 0;
            wait(0.2);
            servo = 0.3;
            wait(0.1);
        }else{
            servo = 0.5;
            ledClick = 0;
        }
     }
}

//serial Thread
void serialRecieve(void const *arg){
    while(true){
        if(pc.readable() > 0){
            printMutex.lock();
            clickCount += pc.getc();
            pc.printf("%d\n" , clickCount);
            printMutex.unlock();
        }
    }
}

//sw isr
void swPressedIsr(){
    ledEnable = !ledEnable;
    //restart click and clear clickCount
    if(!clickEnable) clickCount = 0;
    clickEnable = !clickEnable;
}

//mbed is alive
void ledBlinkIsr(){
    ledMbedAlive = !ledMbedAlive;
}

int main() {
    sw.mode(PullUp);
    
    clickCount = 0;
    clickEnable = true;
    ledEnable = 1;
    
    //sw debounce
    sw.attach_deasserted(&swPressedIsr);
    sw.setSampleFrequency();
    //led
    Ticker ledBlinker;
    ledBlinker.attach(&ledBlinkIsr,0.5);
    
    Thread servoThread(servoMove);
    Thread serialThread(serialRecieve);
    printMutex.lock();
    pc.printf("\nStart!\n");
    printMutex.unlock();
    while (1) {
        if(clickCount > 0 && clickEnable){
            ledClickContinue = 1;
            printMutex.lock();
            pc.printf("click!\n");
            printMutex.unlock();
            mouse.click(MOUSE_LEFT);
            clickCount--;
            Thread::wait(0.02);
        }else{
            ledClickContinue = 0;
        }
    }
}