#include "mbed.h"
#include "QEI.h"

#ifndef DC_MOTOR_CONTROLLER_H
#define DC_MOTOR_CONTROLLER_H

class DC_Motor_Controller {
    
    public:
        DigitalOut out1, out2;    //  Motor direction control pin 2
        DC_Motor_Controller(PinName out1_p, PinName out2_p, PinName in1_p,  PinName in2_p, int PPR) : out1(out1_p), out2(out2_p), dc_motor(in1_p, in2_p, NC, PPR)
        {
            }
        
        void reset(){       // Setting home point for increment encoder
            /*while (home_button == 0){       // Continue to turn clockwise until home button pressed
                out1 = 1;
                out2 = 0;
            }*/
            out1 = out2 = 0;
            dc_motor.reset();       //  Reset pulse_
            //wait(1);
         };
         
        void move_angle(int angle){      //  move for relative distance
            reset();
            goto_angle(angle);
            reset();
        };
        
    private:        
        QEI dc_motor;    //(D8,D7,NC,792);    // Create QEI object for increment encoder
        void goto_angle(int angle){      //  Move motor to specific angle from home point
            int tar_pulse = ((double) angle / 360.0)* (2.0 * 792.0);    //  Calculating target pulse number
            int cur_pulse = dc_motor.getPulses();
            
            while ( tar_pulse != cur_pulse ){
        
                if (tar_pulse > cur_pulse){     //  Rotate motor clockwise
                    out1 = 1;
                    out2 = 0;
                }
                else {                          //  Rotate motor counter clockwrise 
                    out1 = 0;
                    out2 = 1;
                }
                cur_pulse = dc_motor.getPulses();   //  Get increment encoder current pulse number
            }
            out1 = 0;       //  Stop motor
            out2 = 0;
        };
    
};
#endif