#include "mbed.h"
#include "GYRO_DISCO_L476VG.h"
#include "COMPASS_DISCO_L476VG.h"
//
#define TE 0.01
#define F0 0.1
#define H 1

GYRO_DISCO_L476VG gyro;
COMPASS_DISCO_L476VG compass;
Serial pc(SERIAL_TX, SERIAL_RX,115200);
Ticker ticker;
DigitalOut led1(LED1);
volatile bool flag=0;

double psiafiltre[2];
double psia[2]={0};
double coef[2];

double psig[2]={0};
double psigfiltre[2];
double coef2[2];

double inclonometre ;
double T;

double gyro_zero(void)
{
    const int NN=10000;
    float GyroBuffer[3];
    double gy_off=0;
    for(int i=0; i<NN; i++) {
        gyro.GetXYZ(GyroBuffer);
        gy_off=gy_off+GyroBuffer[1]/NN;
    }
    return(gy_off);
}
double angle_zero(void)
{
    const int NN=1000;
    int16_t AccBuffer[3];
    double PI=4*atan(1.0);
    double ang_off=0;
    for(int i=0; i<NN; i++) {
        compass.AccGetXYZ(AccBuffer);
        double ang=(180/PI)*atan2((double)AccBuffer[0],(double)AccBuffer[2]);
        ang_off=ang_off
                +ang/NN;
    }
    return ang_off;
}
void filtre_PB(double* xn,double* yn,double* coef1)
{
    yn[0] = (xn[0]+xn[1])*coef1[0]- yn[1]*coef1[1];
    yn[1]= yn[0];
    xn[1] = xn[0];

}

void coef_filtre_PB(double H10,double f10,double TeE,double* cof)
{

    float T2 ;
    T2=1.00/(3.14*f10);
    cof[0]=TeE*H10/(TeE+T2) ;
    cof[1]=(TeE-T2)/(TeE+T2);
}

void mesure(void)
{
    flag=1;
}
int main()
{
    float GyroBuffer[3];
    int16_t AccBuffer[3];
    printf("Super inclinometre\n\r");
    double PI=4*atan(1.0);
    double gyr_off=gyro_zero();
    double ang_off=angle_zero();
    ticker.attach(&mesure,TE);
    coef_filtre_PB(H,F0,TE,coef);
    T=(1.00/(2*3.14*F0));
    coef_filtre_PB(T,F0,TE,coef2);

    unsigned char cpt=0;

    while(1) {
        if(flag) {
            compass.AccGetXYZ(AccBuffer);
            psia[0]=((180.0/PI)*atan2((double)AccBuffer[0],(double)AccBuffer[2]))-ang_off;
            filtre_PB(psia,psiafiltre,coef);
            gyro.GetXYZ(GyroBuffer);
            psig[0]=(GyroBuffer[1]-gyr_off)/1000;
            filtre_PB(psig,psigfiltre,coef2);

            if(cpt==9) {
                cpt=0;
                
                led1 = !led1;
                inclonometre= psiafiltre[0]+psigfiltre[0];
                pc.printf("$%f %f %f;\n",psiafiltre[0],psigfiltre[0],inclonometre);
            }
            cpt++;
            flag=0;
        }
    }
}
