#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"

#include "Game.h"


//already defined
//#define SIZE_X       128
//#define SIZE_Y       128
 
//display
uLCD_4DGL lcd(p28,p27,p29); // serial tx, serial rx, reset pin;

//inputs
AnalogIn sliderh(p17);
AnalogIn sliderv(p19);
DigitalIn button(p20);

//outputs
AnalogOut aout(p18);

//game objects
Controller  controller(sliderh, sliderv, button);
vec2        screen = {SIZE_X, SIZE_Y};
Renderer    gfx(lcd, screen);
Audio       audio(aout);
Game        game(gfx, audio, controller);


void thread_audio( void const *args ){
       audio.run();
}
int main() {
    lcd.baudrate(3000000);
    gfx.background = Color(0x444444); 
    lcd.background_color(gfx.background);
    lcd.cls();
    
    Thread t_audio(thread_audio);   //start the audio
    
    while(true){
        game.loop();
        //Thread::wait(10);
    }
}