#include <vector>
#include <string>
#include <list>

struct vec2 {
  float x;
  float y;  
};

class Physics;
class Renderer;

class Color{
  public: 
    unsigned char r;
    unsigned char g;
    unsigned char b;
    
    Color() : r(0), g(0), b(0)
    {}
    Color(unsigned char r, unsigned char g, unsigned char b) : r(r), g(g), b(b)
    {}
    Color(int c) : r( (c & 0xff0000) >> 16), g( (c & 0xff00) >> 8), b(c & 0xff)
    {}
    
    operator int(){
        int c = 0;
        return c | (r << 2*8) | (g << 8) | b;    
    }
};


class Block{
friend Physics;
friend Renderer;

private:


  vec2 next_coord;
  vec2 next_size;
  vec2 next_velocity;
  
public:
  bool updated;
  bool locked;              //fixed position
  bool interactive;         //collidable in physics
  bool render;
  vec2 coord;
  vec2 size;
  vec2 velocity;
  Color color;
  
  vec2 prev_coord;
  vec2 prev_size;
  
  Block() :  updated(true), locked(false), interactive(true), render(true)
  {
      coord.x = 0;
      coord.y = 0;
      velocity.x = 0;
      velocity.y = 0;
      color = RED;
      size.x = 2;
      size.y = 2;
  }
  
  virtual bool touching(const Block& b){      
      if (  coord.x < b.coord.x + b.size.x      &&
            coord.x + size.x > b.coord.x        &&
            coord.y < b.coord.y + b.size.y      &&
            size.y + coord.y > b.coord.y
         )
      {
          if(this == &b){
              return false;
          }
          return true;
      }
      return false;
  }
  virtual void next_swap(){
      coord = next_coord;
      size = next_size;
      velocity = next_velocity;   
  }
  void store_prev(){   
      prev_coord = coord;
      prev_size = size;
  }
  void copy(){
      prev_coord = coord;
      prev_size = size;
      
      next_coord = coord;
      next_size = size;
      next_velocity = velocity;
  }
};

class Text{
  public:
    bool updated;
    std::string message;
    vec2 coord;
    Color color; 
    int font;
    Text() : color(0xffffff), updated(true)
    {    
    }
};
class Scene{
public:
    int lives;
    int score;
    bool beat;
    
    Color bg;

    Block paddle;
    Block ball;
    std::list<Block> blocks;
    std::vector<Text> text;
};


class Renderer{
private:
public:
    uLCD_4DGL& g;
    Color background;
    vec2 screen;
    
    Renderer(uLCD_4DGL& gfx, vec2 screen) : g(gfx), screen(screen)
    {
    }
    void render(Scene s){
       //g.cls();
       
       // draw blocks
       for(std::list<Block>::iterator b = s.blocks.begin(); b != s.blocks.end(); b++){
            if(b->updated){
                //draw over where it was
                //g.filled_rectangle(b->prev_coord.x, b->prev_coord.y, b->prev_coord.x+b->prev_size.x, b->prev_coord.y+b->prev_size.y, background);       //x1,y1,x2,y2,color
                //draw new location
                g.filled_rectangle(b->coord.x, b->coord.y, b->coord.x+b->size.x, b->coord.y+b->size.y, b->color);       //x1,y1,x2,y2,color
                
                b->updated = false;
            }
       } 
       
       

       //draw paddle
       {
       Block* b = &(s.paddle);       
       if(b->updated){
            //draw over where it was
            g.filled_rectangle(b->prev_coord.x, b->prev_coord.y, b->prev_coord.x+b->prev_size.x, b->prev_coord.y+b->prev_size.y, background);       //x1,y1,x2,y2,color
            //draw new location
            g.filled_rectangle(b->coord.x, b->coord.y, b->coord.x+b->size.x, b->coord.y+b->size.y, b->color);       //x1,y1,x2,y2,color
            
            b->updated = false;
       }
       }
       
       
       //draw ball
       {
       Block* b = &(s.ball);       
       if(b->updated){
            //draw over where it was
            g.filled_rectangle(b->prev_coord.x, b->prev_coord.y, b->prev_coord.x+b->prev_size.x, b->prev_coord.y+b->prev_size.y, background);       //x1,y1,x2,y2,color
            //draw new location
            g.filled_rectangle(b->coord.x, b->coord.y, b->coord.x+b->size.x, b->coord.y+b->size.y, b->color);       //x1,y1,x2,y2,color
            
            b->updated = false;
       }
       }
       
       
       //draw text
       for(size_t i = 0; i < s.text.size(); i++){
            Text& t = s.text[i];
            if(t.updated){
                g.set_font(t.font);
                g.color(t.color);
                g.locate(t.coord.x, t.coord.y);
                g.printf(t.message.c_str());
                t.updated = false;
            }
       } 
       
    }  
};