#include "a101.h"
#include "mbed.h"

int padding;

a101::a101(PinName CKI, PinName SDI, int ledLength, int tapeLength) : _CKI(CKI), _SDI(SDI), _ledLength(ledLength), _tapeLength(tapeLength) {
    clear();
}

void a101::post(int *strip_colors) {
    for (int i = 0; i < 32; i++) {
        padding0();
    }
    
    wait_us(RESET_DERAY);
    
    for (int tapeNum = 0; tapeNum < _tapeLength; tapeNum++) {
        for(int ledNum = 0; ledNum < _ledLength; ledNum++) {
            operate();
            for (int color = 0; color <= 2; color++) {
                int color_level = (strip_colors[tapeNum*24+ledNum] & (0xff << (8*color))) >> (8*color);
                for (int color_bit = 7; color_bit >= 0; color_bit--) {
                    if (color_level & (1 << color_bit)) padding1();
                    else padding0();
                }
            }
        }
    }
    for (padding = 0; padding < 12*_ledLength*_tapeLength; padding++) {
        padding1();
    }
}

void a101::padding1() {
    _CKI = 0;
    _SDI = 1;
    _CKI = 1;
}

void a101::padding0() {
    _CKI = 0;
    _SDI = 0;
    _CKI = 1;
}

void a101::operate() {
    for (int i = 0; i < 8; i++) {
        padding1();
    }
}

void a101::clear() {
    for (int i = 0; i < 32; i++) {
        padding0();
    }
    
    wait_us(RESET_DERAY);
    
    for (int tape = 0; tape < _tapeLength; tape++) {
        for (int led = 0; led < _ledLength; led++) {
            operate();
            for (int bit = 0; bit < 24; bit++) {
                padding0();
            }
        }
    }
    for (padding = 0; padding < 12*_ledLength*_tapeLength; padding++) {
        padding1();
    }
}

