#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"

#include "a101.h"
#include "string.h"

#define LED_LENGTH 24
#define TAPE_LENGTH 10
#define TCP_LISTENING_PORT 50505

            
char color[] = "0x000000";
char *error;
int ledColors[LED_LENGTH*TAPE_LENGTH] = {0};
a101 ledTape(p13, p14, LED_LENGTH, TAPE_LENGTH);

void onTCPSocketEvent(TCPSocketEvent e) ;
void onConnectedTCPSocketEvent(TCPSocketEvent e) ;

EthernetNetIf eth;
TCPSocketErr tcpErr ;
TCPSocket tcpSock ;
TCPSocket* pConnectedSock ;
Host client ;

int main() {
    printf("Setting up...\r\n");
    EthernetErr ethErr = eth.setup() ;
    if ( ethErr != ETH_OK ) {
        printf("Error %d in setup.\r\n", ethErr ) ;
    return -1 ;
    }
    printf("Setup OK\r\n") ;
    IpAddr ip = eth.getIp() ;
    printf("mbed IP Address is [%d.%d.%d.%d]\r\n", ip[0], ip[1], ip[2], ip[3] ) ;

    tcpSock.setOnEvent(&onTCPSocketEvent) ;

    printf("Bindding...\r\n") ;
    tcpErr = tcpSock.bind(Host(IpAddr(), TCP_LISTENING_PORT)) ;
    if ( tcpErr != ETH_OK ){
        printf("Bindding Error.\r\n") ;
        return -1 ;
    }
    
    printf("Listen...\r\n");
    tcpErr = tcpSock.listen() ;
    if ( tcpErr != ETH_OK ){
        printf("Listen Error.\r\n") ;
        return -1 ;
    }

    while(1) {
        Net::poll() ;
    }
}

void onTCPSocketEvent(TCPSocketEvent e) {
    if (e != TCPSOCKET_ACCEPT) return;
    
    printf("Listening: TCP Socket Accepted\r\n") ;

    tcpErr = tcpSock.accept(&client, &pConnectedSock) ;
    if (tcpErr != TCPSOCKET_OK) {
        printf("onTCPSocketEvent Error\r\n") ;
        return ;
    }

    pConnectedSock->setOnEvent(&onConnectedTCPSocketEvent) ;
        
    IpAddr clientIp = client.getIp();
        printf("Controler IP Address is [%d.%d.%d.%d]. \r\n", clientIp[0], clientIp[1], clientIp[2], clientIp[3]);
}

void onConnectedTCPSocketEvent(TCPSocketEvent e) {
    char buf[3000];

    switch(e) {
        case TCPSOCKET_CONNECTED:
            printf("Connected to host.\r\n");
            break ;
        case TCPSOCKET_WRITEABLE:
            printf("Can write data to buf.\r\n");
            break ;
        case TCPSOCKET_READABLE:
            pConnectedSock->recv(buf, sizeof(buf));
            for (int i = 0; i < LED_LENGTH*TAPE_LENGTH; i++) {
                for (int j = 0; j < 6; j++) {
                    color[j+2] = buf[i*6+j];
                }
                ledColors[i] = strtol(color, &error, 0);
            }
            ledTape.post(ledColors);
            break ;
        case TCPSOCKET_CONTIMEOUT:
            printf("Connection timed out.\r\n");
            break;
        case TCPSOCKET_CONRST:
            printf("Connection was reset by remote host.\r\n");
            break;
        case TCPSOCKET_CONABRT:
            printf("Connection was aborted.\r\n");
            break;
        case TCPSOCKET_ERROR:
            printf("Unknown error.\r\n");
            break;
        case TCPSOCKET_DISCONNECTED:
            printf("TCP Socket Disconnected\r\n");
            pConnectedSock->close() ;
            break;
    }
}

