#include "mbed.h"

/***********************************************************************
* Read temperature by using DS1631
*
* Normal I2C-protocol (start,write,..,stop) does NOT work
* It has to be used 
*   i2c.write(address,data,length,repeat) 
* which includes start and stop and a special addressing function
************************************************************************/
DigitalOut myled(LED2);
DigitalIn button(USER_BUTTON);
I2C i2c (PB_9,PB_8);           // sda, scl

int main() {
    int data;
    uint16_t cr1;
    int ack;
    char data_write[2];
    char data_read[2];
    //cr1 = I2C1->CR1;
    //I2C1->CR2 = 0x0002;
     
    data_write[0] = 0xEE;
    ack = i2c.write(0x90, data_write, 1, 0);       
    data_write[0] = 0xAC;               // writes the 1-byte configuration register
    data_write[1] = 0x0F;               // 1shot;12bit;pol=1
    ack = i2c.write(0x90, data_write, 2, 0);       

    while(1) {
        while (button);                 // start measurement by user_button
 
        data_write[0] = 0x51;           // Initiates temperature conversions
        ack = i2c.write(0x90, data_write, 1, 0);       
        //printf("%d\n",ack);
        wait_ms(1000);
         
        data_write[0] = 0xAA;           // Reads last converted temperature value from the 2-byte temperature register
        ack = i2c.write(0x90, data_write, 1, 1);     
        i2c.read(0x90, data_read, 2, 0); 
         
        data=data_read[0]*100;
        data=data+(((data_read[1] >> 4 )* 50)/8);
        printf("%d\n",data);
        //wait_ms(1000);               
    }
}
