#ifndef PARAMETER_DEFINITION_H
#define PARAMETER_DEFINITION_H
/***********************************************************************************************
                                 definition constant vaule
***********************************************************************************************/
enum can_pin_number { CAN_TD , CAN_RD , CAN_PIN_NUMNBER};
enum encoder_pin_number { ENCODER_A , ENCODER_B , ENCODER_PIN_NUMBER};
enum led_pin_number { CW , CCW, FREE , LED_PIN_NUMBER};
enum a3921_pin_number { PWMH , PHASE , A3921_PIN_NUMBER};
enum serial_pin_number { SERIAL_TX , SERIAL_RX , SERIAL_PIN_NUMBER};
enum id_switch_pin_number { SWITCH1 , SWITCH2 , SWITCH3 , SWITCH4 , SWITCH_PIN_NUMBER};

enum parameter_number { KP , KI , KD , ACCELERATION ,PARAMETER_NUMBER};

namespace communication_baud {
    const int CAN = 1000000;         //CAN通信の通信速度(Hz)
    const int PC  = 460800;         //Serial通信の通信速度(bps)
};

const int ENCODER_PPR = 512;        //ロータリーエンコーダのPPR

namespace motor_option {
    const float FREQUENCY = 20000.0f;   //Motorの動作周波数
    const float UPPER_LIMIT = 1.0f;     //Dutyの上限
    const float LOWER_LIMIT = -1.0f;    //Dutyの下限
};

namespace period {
    const float CONTROL_CYCLE = 0.01f;  //制御周期
};

const float TIMEOUT_VALUE = 10.0f;       //CAN通信のTIMEOUT時間
/************************************************************************************************
                                     definition pin
************************************************************************************************/
#if MOTOR_DRIVER_VERSION == 4
//MD_ver 4.0
const PinName CAN_PIN[CAN_PIN_NUMNBER] = {P0_18,P0_13};                     //{CAN_TD,CAN_RD}
const PinName ENCODER_PIN[ENCODER_PIN_NUMBER] = {P0_6,P0_5};                //{Encoder_Apulse,Encoder_Bpulse}
const PinName LED_PIN[LED_PIN_NUMBER] = {P0_25,P0_26,P0_27};                //{CW,CCW,Free}
const PinName A3921_PIN[A3921_PIN_NUMBER] = {P0_12,P0_10};                  //{PWMH,PHASE}
const PinName SERIAL_PIN[SERIAL_PIN_NUMBER] = {P0_28,P0_29};                //{Serial TX,Serial RX}
const PinName ID_PIN[SWITCH_PIN_NUMBER] = {P0_19,P0_20,P0_15,P0_17};        //{Switch pin}
const PinName PWML_PIN = P0_11;                                             //PWML pin
#elif MOTOR_DRIVER_VERSION == 5
//MD_ver 5.0
const PinName CAN_PIN[CAN_PIN_NUMNBER] = {P0_18,P0_13};                     //{CAN_TD,CAN_RD}
const PinName ENCODER_PIN[ENCODER_PIN_NUMBER] = {P0_6,P0_5};                //{Encoder_Apulse,Encoder_Bpulse}
const PinName LED_PIN[LED_PIN_NUMBER] = {P0_14,P0_12,P0_0};                 //{CW,CCW,Free}
const PinName A3921_PIN[A3921_PIN_NUMBER] = {P0_29,P0_28};                  //{PWMH,PHASE}
const PinName SERIAL_PIN[SERIAL_PIN_NUMBER] = {P0_2,P0_1};                  //{Serial TX,Serial RX}
const PinName ID_PIN[SWITCH_PIN_NUMBER] = {P0_25,P0_24,P0_26,P0_27};        //{Switch pin}
#elif MOTOR_DRIVER_VERSION == 6
//MD_ver 6.0
const PinName CAN_PIN[CAN_PIN_NUMNBER] = {P0_18,P0_13};                     //{CAN_TD,CAN_RD}
const PinName ENCODER_PIN[ENCODER_PIN_NUMBER] = {P0_3,P0_2};                //{Encoder_Apulse,Encoder_Bpulse}
const PinName LED_PIN[LED_PIN_NUMBER] = {P0_14,P0_9,P0_28};                //{CW,CCW,Free}
const PinName A3921_PIN[A3921_PIN_NUMBER] = {P0_20,P0_29};                  //{PWMH,PHASE}
const PinName SERIAL_PIN[SERIAL_PIN_NUMBER] = {P0_12,P0_11};                //{Serial TX,Serial RX}
const PinName ID_PIN[SWITCH_PIN_NUMBER] = {P0_5,P0_8,P0_7,P0_6};            //{Switch pin}
#endif
/***********************************************************************************************
                                    definition struct union
***********************************************************************************************/
union can_flame{float f; int i; char c[4];};

#endif