#include "mbed.h"
#include "SCP1000.h"
#include "MSCFileSystem.h"
Serial pc(USBTX,USBRX); ///// connect to PC
DigitalOut sp1(p10);
DigitalOut L1(LED1);
DigitalOut L2(LED2);
DigitalOut L3(LED3);
DigitalOut L4(LED4);
#define FSNAME "msc"
MSCFileSystem msc(FSNAME);
FILE *USB_fp;
int main()
{
    pc.printf("\n\nMBED START UP\n\n");
    pc.printf("3\n");
    L4=1;
    int L1_mode,L2_mode,L3_mode,L4_mode;
    pc.printf("2\n");
    L3=1;
    SCP1000 scp1000(p11, p12, p13, p14 , SCP1000::HIGH_SPEED_MODE );
    scp1000.setOperationMode(SCP1000::HIGH_SPEED_MODE);
    float scp_pressure,scp_temperature;
    float bscp_pressure,bscp_temperature;
    float ascp_pressure,ascp_temperature;
    pc.printf("1\n");
    L2=1;
    char totaldata[512];
    int i=0;
    pc.printf("READY GO!\n\n");
    pc.printf("0\n");
    L1=1;
    while(1)
    {
        scp_pressure = scp1000.readPressure();
        scp_temperature = scp1000.readTemperature();
        L1_mode=L1; L2_mode=L2;
        L3_mode=L3; L4_mode=L4;
        ascp_pressure=bscp_pressure*0.9+scp_pressure*0.1;
        ascp_temperature=bscp_temperature*0.9+scp_temperature*0.1;
        sprintf(totaldata,"%d,%f,%f,%d,%f,%f,%d,%d,%d,%d\n",
            i,scp_pressure, scp_temperature,i,ascp_pressure,ascp_temperature,
            L1_mode,L2_mode,L3_mode,L4_mode);
        pc.printf("%d,%f,%f,%d,%f,%f,%d,%d,%d,%d\n",
            i,scp_pressure, scp_temperature,i,ascp_pressure,ascp_temperature,
            L1_mode,L2_mode,L3_mode,L4_mode);
            i++;
            bscp_pressure=ascp_pressure;
            bscp_temperature=ascp_temperature;
            if(sizeof(i)>0)
            {
            USB_fp = fopen( "/" FSNAME "/data.txt", "a");
            if ( USB_fp != NULL ) fprintf(USB_fp, "%s\r\n",totaldata);
            fclose(USB_fp);
        }
        L1=0;L2=0;L3=0;L4=0;
        if(i%4==0) {L1=1;}
        else if(i%4==1){L2=1;}
        else if(i%4==2){L3=1;}
        else if(i%4==3){L4=1;}
    }

}