#ifndef LIBCAP_H
#define LIBCAP_H

#include "mbed.h"

class CapIn
{
public:
    /**
     * Constructor.
     *
     * Creates a object for capacitive measurement on digital pin using default timer.
     *
     * @param pin - Digital input pin
     */
    CapIn(PinName pin);
    /**
     * Constructor.
     *
     * Creates a object for capacitive measurement on digital pin using custom timer.
     *
     * @param pin - Digital input pin
     * @param timer - Timer[0-4] uesed for measurement
      */
    CapIn(PinName pin, int timer);
    int read_uF();
    int read_t();
private:
    DigitalIn _pin;
};

#endif /* LIBCAP_H */