#include "mbed.h"
#include "conio.h"

Serial pc(USBTX, USBRX);

int get_esc_sec () {
    int ch;
    if (pc.scanf("\x1b\x5b%c",ch) == 0)
        return 0;
    else
        return ch;
}

int _kbhit (void) {
    return pc.readable();
}


void _putch (char ch) {
    pc.putc(ch);
}

int _getch (void) {
    int ret;

    while (!_kbhit()); //wait and read new char
    ret = pc.getc();
    if (ret==0) {
        while (!_kbhit()); //wait and read new char
        ret = pc.getc();
        ret = ret | 0x100;
    }

    return ret;
}


void MCU_Init(void) {
    pc.baud(19200);
}