#include "mbed.h"
#include "Display.h"


const unsigned char rorschachSmall [] = {
0x7F, 0xEB, 0x57, 0xFF, 0xF7, 0xFD, 0xB7, 0xFF, 0xCD, 0xFF, 0xFB, 0xEF, 0xBF, 0xFF, 0xED, 0xBF,
0x3F, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0xC0, 0x80, 0x80, 0xC0, 0x80, 0x88, 0xA0, 0x00, 0x48, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00,
0x05, 0x7F, 0xDF, 0xFF, 0xF7, 0xBF, 0xFF, 0xDF, 0xFB, 0xFF, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xFB,
0x57, 0xBF, 0xBF, 0xEF, 0x9F, 0x5F, 0xB7, 0xDE, 0x8F, 0xDE, 0x17, 0xCF, 0x8E, 0x1D, 0x8F, 0x03,
0x08, 0x02, 0x10, 0x00, 0x00, 0x31, 0x06, 0x1D, 0x1F, 0x3B, 0x16, 0x7F, 0x1F, 0x3F, 0x7F, 0x3F,
0x5F, 0x3F, 0x7F, 0x3F, 0x2A, 0x7F, 0x0C, 0x73, 0x0C, 0x29, 0x80, 0x00, 0x00, 0x81, 0x08, 0x20,
0x41, 0x17, 0x5F, 0x7E, 0xFB, 0x5F, 0xFF, 0xFD, 0xD7, 0xFF, 0xFF, 0xFE, 0xFB, 0xB7, 0xFF, 0xFF,
0xFF, 0xFE, 0xFF, 0xF8, 0xEF, 0xFB, 0x64, 0xFF, 0xCA, 0xF5, 0x8F, 0xFB, 0x96, 0xFD, 0x27, 0x89,
0x00, 0x29, 0x02, 0x40, 0x76, 0xF0, 0xE2, 0x8C, 0x80, 0x18, 0x68, 0xF8, 0xF0, 0x70, 0xF0, 0x00,
0xF0, 0x60, 0xC0, 0xF0, 0xE0, 0x40, 0x20, 0x20, 0xC0, 0xA0, 0xC0, 0xE0, 0x20, 0x40, 0x20, 0x50,
0x00, 0xF0, 0x20, 0xD0, 0xF0, 0x30, 0xE0, 0x18, 0xF0, 0x19, 0xE8, 0x91, 0xED, 0x59, 0xED, 0xEB,
0xF7, 0xFF, 0xEF, 0xFF, 0xFE, 0xF7, 0xFF, 0xFD, 0xFF, 0xAB, 0x7E, 0xFF, 0xFF, 0xEB, 0x00, 0x00,
0x05, 0x03, 0x02, 0x00, 0x00, 0x10, 0x5D, 0x7F, 0x7F, 0x7E, 0xEB, 0xF1, 0xA3, 0x1E, 0xFE, 0xC4,
0xFE, 0x3D, 0x8B, 0xE0, 0x57, 0x7C, 0x7C, 0x7F, 0xBF, 0x22, 0x00, 0x04, 0x22, 0x0D, 0x0C, 0x37,
0x40, 0x45, 0xFF, 0xFE, 0xD7, 0xFE, 0xFF, 0xDF, 0xFB, 0xFF, 0xCB, 0xFF, 0xD7, 0xFF, 0xBF, 0xFF,
0xFF, 0xBD, 0xFF, 0xFF, 0xD7, 0xFE, 0xFF, 0xBF, 0x3F, 0x2B, 0x9F, 0x0F, 0x8F, 0x03, 0x16, 0x60,
0x80, 0x0A, 0x06, 0x0A, 0x82, 0x3E, 0x20, 0x00, 0x00, 0xC1, 0x01, 0x03, 0x17, 0xF4, 0xF9, 0x78,
0xF9, 0xF4, 0xAD, 0x03, 0x83, 0x00, 0x81, 0x00, 0x40, 0x34, 0x14, 0x04, 0x04, 0x8E, 0xA0, 0x00,
0x1D, 0x1F, 0x7F, 0x7C, 0xF7, 0xFF, 0xBD, 0xFF, 0xFB, 0xBF, 0xFD, 0xD7, 0xFF, 0xDF, 0xFF, 0xFF,
0x3F, 0x0F, 0x2B, 0x07, 0x03, 0x21, 0x00, 0x02, 0x48, 0x10, 0xA2, 0x08, 0x34, 0xC3, 0x3C, 0x83,
0x1A, 0x60, 0x80, 0x00, 0x04, 0x00, 0x04, 0x08, 0x43, 0xDF, 0x39, 0xE7, 0x77, 0xFF, 0xFB, 0x30,
0xF7, 0xFF, 0xFF, 0xE2, 0xBB, 0xAF, 0xC2, 0x84, 0x08, 0x00, 0x40, 0xC4, 0x18, 0x07, 0x7C, 0xCA,
0xB0, 0xA4, 0x00, 0x40, 0x81, 0x01, 0x83, 0x07, 0x07, 0x06, 0x1F, 0x1E, 0x5F, 0x3B, 0xFF, 0xFF,
0xA8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x01, 0x5C, 0x62, 0xDC, 0xF1, 0x2E, 0xD8, 0x27,
0x78, 0xC4, 0xB3, 0x24, 0xCA, 0x38, 0xE0, 0x01, 0xFC, 0x8F, 0x89, 0x81, 0x9C, 0xBB, 0xB3, 0x80,
0x13, 0xFB, 0xA7, 0x40, 0xD5, 0xCE, 0xFA, 0x34, 0xE8, 0x4C, 0xCB, 0xB2, 0xC8, 0xB0, 0x55, 0xB2,
0xCE, 0x30, 0xF5, 0x0F, 0x52, 0x08, 0x00, 0x00, 0x04, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
0x3E, 0x2A, 0x5C, 0x1E, 0x38, 0x52, 0x38, 0x50, 0x30, 0x29, 0xF0, 0x21, 0x73, 0xA6, 0x52, 0x2D,
0xFC, 0x49, 0xF3, 0x5D, 0xFF, 0xFA, 0xD5, 0xFE, 0x77, 0xFF, 0xF4, 0xFF, 0xF7, 0xDE, 0xFF, 0xFF,
0xFF, 0xBD, 0xDF, 0xF3, 0xDF, 0xE4, 0x7F, 0xEF, 0xEB, 0xB7, 0xCA, 0x35, 0xF8, 0x2C, 0x8F, 0x32,
0x4B, 0x82, 0x58, 0x2A, 0xC0, 0x20, 0xCC, 0xE1, 0xA0, 0xE0, 0xE1, 0xA0, 0x60, 0xB0, 0x48, 0x70
};



int main() {
    Display display (p21, p22, p23, p24, p25, p5, p6, p7, p8, p9, p10, p11, p12);
    DisplayTTY text (&display, 2, 1, 20, 1);
    text.cls();
    Serial pc(USBTX, USBRX);
    pc.baud(19200);
    
    for (int c=0;c<64;c++) {
        for (int r=0;r<8;r++)
        {
            display.write(r,c,rorschachSmall[r*64+c]);
            
        }
    }
    while(1) {
        if(pc.readable()) {
            text.putc(pc.getc());
        }
    }
}