#include "player.h"
#include "background.h"

player::player()

:
    _led1(new PwmOut(PTA1)),
    _led2(new PwmOut(PTA2)),
    _led3(new PwmOut(PTC2)),
    _led4(new PwmOut(PTC3)),
    _led5(new PwmOut(PTC4)),
    _led6(new PwmOut(PTD3)),

    _button_A(new InterruptIn(PTB9)),
    _button_B(new InterruptIn(PTD0)),
    _button_X(new InterruptIn(PTC17)),
    _button_Y(new InterruptIn(PTC12)),
    _button_L(new InterruptIn(PTB18)),
    _button_R(new InterruptIn(PTB3)),
    _button_back(new InterruptIn(PTB19)),
    _button_start(new InterruptIn(PTC5)),
    _button_joystick(new InterruptIn(PTC16)),

    _vert(new AnalogIn(PTB10)),
    _horiz(new AnalogIn(PTB11)),

    _buzzer(new PwmOut(PTC10)),
    _pot(new AnalogIn(PTB2)),

    _timeout(new Timeout()),

    _event_state(0),

    _x0(0),
    _y0(0)
{}





player::~player()
{

    delete _led1,_led2,_led3,_led4,_led5,_led6;
    delete _button_A,_button_B,_button_joystick,_vert,_horiz;
    delete _button_X,_button_Y,_button_back,_button_start;
    delete _button_L,_button_R, _buzzer, _pot, _timeout;


}
Vector2D player::get_player_coord(){
     const char array[3][3]={
    {1,1,1},
    {1,1,1},
    {1,1,1},
    };
    
    }

void player::init(int x,int y){

  const char array[3][3]={
    {1,1,1},
    {1,1,1},
    {1,1,1},
    };
    _speed=1:
     setXYAddress(2,2); 
    }

void player::read_input(background &pad)
{
    _d = pad.get_direction();
    //_mag = pad.get_mag();
}

void player::move_update()
{
    
}

void player::update(Direction d)
{
  
    const char map[48][85] = get_mapped_coord();
    Vector2D monsterPos = get_pos();
    if(A_PRESSED){
        if(map[Y][X+5]==1){
             setXYAddress(X,Y);
            }
        else{setXYAddress(X+5,Y);}
    }
    else if (B_PRESSED){
        if(map[Y+5][X]==1){
             setXYAddress(X,Y);
            }
        else{setXYAddress(X,Y+5);}
        }
    else if (d == N) { 
        if(map[Y+3][X]==1){
            setXYAddress(X,Y);
        }
        else if (map[Y+3][X+2]==1){
            setXYAddress(X,Y);
        }     
        else{ 
            setXYAddress(X,Y+1); 
        }
    } 
    else if (d == S) {
        if(map[Y-1][X]==1){
            setXYAddress(X,Y);
        }
        else if(map[Y-1][X+2]==1){
            setXYAddress(X,Y);    
        }
        else{   
            setXYAddress(X,Y-1);
        }   
    }else if (d == W) {
        if(map[Y][X-1]==1){
            setXYAddress(X,Y);    
        }
        else if(map[Y+2][X-1]==1){
            setXYAddress(X,Y);
        }    
        else{
            setXYAddress(X-1,Y); 
        }  
    }else if (d == E) {
        if(map[Y][X+3]==1){
            setXYAddress(X,Y);
        }
        else if(map[Y+2][X+3]==1){
            setXYAddress(X,Y);
        }
        else{
            setXYAddress(X+1,Y);
        }   
    }
}


if(pin==(40,24)){
     lcd.printString("    GOAL    ",0,2);  
    }
if(pin==(83,43) ){
    lcd.printString("   FAKE     ",0,2);
     lcd.printString("  Find the other way  ",0,2);
    lcd.refresh();  
    }

if(pin==(56,4)){
     leds_on(0.2);
     lcd.printString("   trap    ",0,2);
     leds_off(0.2);
     lcd.printString("  Find the other way  ",0,2);
     lcd.refresh();
     setXYAddress(2,2); 
}
if(pin==(77,29)){
     leds_on(0.2);
     lcd.printString("   trap    ",0,2);
     lcd.refresh();
     leds_off(0.2);
   
     setXYAddress(2,2); 
}
if(pin==(65,40)){
     leds_on(0.2);
     lcd.printString("   JUMP    ",0,2);
     leds_off(0.2);
    lcd.refresh();
     setXYAddress(65,30); 
}
        
        