///////// pre-processor directives ////////
#include "mbed.h"
#include "background.h"
#include "N5110.h"
#include "player.h"




struct UserInput {
    Direction d;
    float mag;
};
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
background map;
player ply;


void init();
void update_game(UserInput input);
void render();
void welcome();

int main()
{
    int fps = 8;  

    init();
    welcome();
    
    render();  
    wait(1.0f/fps);  


    while (1) {
        ply.read_input(map);
        //ply.update(map);
        render();
        wait(1.0f/fps);
    }
}

void init()
{

    lcd.init();
  
     

}

void render()
{
    lcd.clear();  
  
    lcd.refresh();
}

void welcome() {
    
    lcd.printString("     MAZE    ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     

 
    while ( map.check_event(background::START_PRESSED) == false) {
        map.leds_on();
        wait(0.1);
        map.leds_off();
        wait(0.1);
    }
 
}