#ifndef BACKGROUND_H
#define BACKGROUND_H

#include <bitset>


namespace mbed
{
class AnalogIn;
class InterruptIn;
class PwmOut;
class Timeout;
}
#define TOL 0.1f
#define RAD2DEG 57.2957795131f
enum Direction {
    CENTRE,  
    N,       
    NE,    
    E,       
    SE,     
    S,       
    SW,      
    W,       
    NW       
};


struct Vector2D {
    float x; 
    float y; 
};


struct Polar {
    float mag;  
    float angle; 
};


class Background
{
    public:
   
enum BackgroundEvent {
    A_PRESSED,    
    B_PRESSED,    
    X_PRESSED,     
    Y_PRESSED,     
    L_PRESSED,     
    R_PRESSED,     
    BACK_PRESSED,  
    START_PRESSED, 
    JOY_PRESSED,   
    N_EVENTS      
};
private:
    mbed::PwmOut *_led1;
    mbed::PwmOut *_led2;
    mbed::PwmOut *_led3;
    mbed::PwmOut *_led4;
    mbed::PwmOut *_led5;
    mbed::PwmOut *_led6;

    mbed::InterruptIn *_button_A;
    mbed::InterruptIn *_button_B;
    mbed::InterruptIn *_button_X;
    mbed::InterruptIn *_button_Y;
    mbed::InterruptIn *_button_L;
    mbed::InterruptIn *_button_R;
    mbed::InterruptIn *_button_back;
    mbed::InterruptIn *_button_start;
    mbed::InterruptIn *_button_joystick;

    mbed::AnalogIn *_vert;
    mbed::AnalogIn *_horiz;

    mbed::PwmOut   *_buzzer;
    mbed::AnalogIn *_pot;

    mbed::Timeout *_timeout;

    std::bitset<N_EVENTS> _event_state; 


    float _x0;
    float _y0;

public:

   
    Background();

  
    ~Background();

   
    void init();

   
    void leds_on();

    
    void leds_off();

   
    void leds(float val) const;

   
    void led(int n,float val) const;

   
    float read_pot() const;

  
    void tone(float frequency, float duration);

   
    bool check_event(BackgroundEvent const id);

  
    float get_mag();

   
    float get_angle();

    
    Direction get_direction();   

   
    Vector2D get_coord();         

 
    Vector2D get_mapped_coord();  

   
    Polar get_polar();            

private:
    void init_buttons();
    void tone_off();

    void a_isr();
    void b_isr();
    void x_isr();
    void y_isr();
    void l_isr();
    void r_isr();
    void back_isr();
    void start_isr();
    void joy_isr();
};

#endif