#include "mbed.h"
#include "uLCD_4DGL.h"
#include "board.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

uLCD_4DGL lcd(p28,p27,p30); // serial tx, serial rx, reset pin;

DigitalIn in0(p11);
DigitalIn in1(p12);
DigitalIn in2(p13);
DigitalIn in3(p14);
DigitalIn in4(p15);
DigitalIn in5(p16);
DigitalIn in6(p17);
DigitalIn in7(p18);
DigitalIn in8(p19);

Mutex stdio_mutex;



int player1=1;
int player2=2;
int turn =1;
int printout = 0;


void printBoard(int ** board)
{
    lcd.cls();
    lcd.line(0, 42 , 127, 42 , 0xFF0000);
    lcd.line(0, 84 , 127, 84 , 0xFF0000);
    lcd.line(42, 0 , 42, 127, 0xFF0000);
    lcd.line(84, 0, 84, 127, 0xFF0000);
    for(int i=0; i<3; i++)
    {
        for(int j=0; j<3; j++)
        {
            if(board[i][j] == 1)
            {
                lcd.line( j*42+2 , i*42 + 2 ,(j+1)*42-2 , (i+1)*42-2 , GREEN);
                lcd.line( j*42+2 , (i+1)*42 - 2 ,(j+1)*42-2 , (i)*42+2 , GREEN);
            }
            else if(board[i][j] == 2)
            {
                lcd.circle(42*j+21, 42*i+21, 19, BLUE);
            }
        }
    }
}

HTTPClient http; 
char str[2048];
int main() {
    
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    printf("%d\n", sizeof(str));
    int ret = http.get("http://ece4180mbedonlinegaming.azurewebsites.net/odata/TicTacToeGames(1)?$select=BoardState", str, 2048);
    printf("%d\n",ret);
    printf("Result: %s\n", str);
    /*
    in0.mode(PullUp);
    in1.mode(PullUp);
    in2.mode(PullUp);
    in3.mode(PullUp);
    in4.mode(PullUp);
    in5.mode(PullUp);
    in6.mode(PullUp);
    in7.mode(PullUp);
    in8.mode(PullUp);
    
    Board board;
    int ** output = board.get_board();
    printBoard(output);
    lcd.baudrate(3000000);
    
    lcd.line(0, 42 , 127, 42 , 0xFF0000);
    lcd.line(0, 84 , 127, 84 , 0xFF0000);
    lcd.line(42, 0 , 42, 127, 0xFF0000);
    lcd.line(84, 0, 84, 127, 0xFF0000);
    
    while (true) {
        if(!in0)
            printout = 1;
        else if(!in1)
            printout = 2;
        else if(!in2)
            printout = 3;
        else if(!in3)
            printout = 4;
        else if(!in4)
            printout = 5;
        else if(!in5)
            printout = 6;
        else if(!in6)
            printout = 7;
        else if(!in7)
            printout = 8;
        else if(!in8)
            printout = 9;
        else
            printout = 0;
            
        
        if(printout>0)
        {
            bool valid = board.updateBoard(turn, printout-1);

            if(valid)
            {
                output = board.get_board();
                printBoard(output);
                printout=0;
                int victory = board.check_victory(turn);
                if(victory ==1)
                {
                    lcd.cls();
                    lcd.printf("player 1 win!");
                    return 0;
                }
                else if(victory == 2)
                {
                    lcd.cls();
                    lcd.printf("player 2 win!");
                    return 0;
                }
                if(turn ==1)
                    turn =2;
                else
                    turn =1;
            }
        }
        Thread::wait(400);
    }   
    */
    
}

