#include "mbed.h"
#include "snimac.h"

#define MEASURE_P   0x31 // 0011 0001
#define TLAKHB      0x2C // 0010 1100
#define TLAKLB      0x2D // 0010 1101
#define RADDR       0xC1 // 1100 0001 Read applied address (test of SPI) neprehozeno
#define MEASURE_A   0x85 // 10000101 133
#define RCAD        0x80 // 128
#define Ahigh       0x81//129
#define Alow        0x83// 131
//odtud prehozeno
#define RSR         0xAD //10110101   general status register
#define IDhigh      0xBC //10111100
#define IDlow       0x2C 
#define IDmid       0x1C
#define mertep      0xB5
#define tep         0xD


#define OTOC(cislo) ((cislo&1)<<7)+((cislo&2)<<5)+((cislo&4)<<3)+((cislo&8)<<1)+((cislo&16)>>1)+((cislo&32)>>3)+((cislo&64)>>5)+((cislo&128)>>7)

extern Serial pc;

//SPI device(PTA16,PTA17,PTA15); // mosi, miso, sclk, ssel
//DigitalOut cs(PTB9);    //chip select

snimac::snimac(PinName mosi, PinName miso, PinName sclk, PinName cps):device(mosi, miso, sclk), cs(cps)
{}

void snimac::init()
{
    cs = 1;
    device.format(8,1); //druhe cislo mod,z dokumentace je to 1
    device.frequency(400000);
}


uint8_t snimac::read(uint8_t adresa)
    {
      cs = 0;
      device.write(adresa);
      cs = 1;
      wait_ms(5);
      
      cs = 0;
      uint8_t data=device.write(0x00);
      cs=1;
      wait_ms(5);
      
      return data;   
    }
    
float snimac::merenitlaku()
{
    cs=0;
    device.write(OTOC(MEASURE_P));
    cs=1;
    wait_ms(5);
    
    cs=0;
    uint8_t dolnibity = read(OTOC(TLAKLB));
    cs=1;
    wait_ms(5);
    
    cs=0;
    uint8_t hornibity = read(OTOC(TLAKHB));
    cs=1;
    wait_ms(5);
    
    short dolniposun = OTOC(dolnibity);
    short horniposun = OTOC(hornibity);
    horniposun = horniposun<<8;
    float vysledek = horniposun + dolniposun;
    vysledek = vysledek * 1.25;
    
    return vysledek;
    }
    
uint8_t snimac::datatlakdolni()
    {
        
    cs=0;
    device.write(OTOC(MEASURE_P));
    cs=1;
    wait_ms(5);
    
    cs=0;
    uint8_t dolnibity = read(OTOC(TLAKLB));
    cs=1;
    wait_ms(5);
    
    dolnibity = OTOC(dolnibity);
    
    return dolnibity;
    
    }
    
uint8_t snimac::datatlakhorni()
    {
        
    cs=0;
    device.write(OTOC(MEASURE_P));
    cs=1;
    wait_ms(5);
    
    cs=0;
    uint8_t hornibity = read(OTOC(TLAKHB));
    cs=1;
    wait_ms(5);
    
    hornibity = OTOC(hornibity);
    
    return hornibity;
    
    }
    
short snimac::mereniteploty()
{
            cs = 0;
            device.write(mertep);
            cs = 1;
            wait_ms(5);
            cs = 0;
            cs = 1;
            //pockej, kvuli SPI???
            wait_ms(5);
            cs = 0;
            uint8_t test1=read(tep);
            cs = 1;
            short vysledek = OTOC(test1)-50;
            //pc.printf("teplota:%d\n\r", vysledek);
            
            return vysledek;
    
}  

uint8_t snimac::datateplota()
{
            cs = 0;
            device.write(mertep);
            cs = 1;
            wait_ms(5);
            cs = 0;
            cs = 1;
            
            wait_ms(5);
            cs = 0;
            uint8_t test1=read(tep);
            cs = 1;
            test1 = OTOC(test1);
            
            return test1;
    
}

float snimac::merenizrychleni()  
{
            cs = 0;
            device.write(OTOC(MEASURE_A));
            cs = 1;
            wait_ms(500);
            cs = 0;
            device.write(OTOC(RCAD));
            //pc1.printf("\n\rodpoved na mereni zrychleni je:%d\n\r", OTOC(test));
            cs = 1;
            wait_ms(500);
            cs = 0;
            uint8_t test1=device.write(OTOC(0x00));
            cs = 1;
            float zrychleni = ((OTOC(test1))* 0.5)-12; 
            //pc.printf("zrychleni:%f\n\r", zrychleni);
            return zrychleni;
}

uint8_t snimac::datazrychleni()
{
            cs = 0;
            device.write(OTOC(MEASURE_A));
            cs = 1;
            wait_ms(500);
            cs = 0;
            device.write(OTOC(RCAD));
            //pc1.printf("\n\rodpoved na mereni zrychleni je:%d\n\r", OTOC(test));
            cs = 1;
            wait_ms(500);
            cs = 0;
            uint8_t test1=device.write(OTOC(0x00));
            cs = 1;
            uint8_t zrychleni = OTOC(test1); 
            //pc.printf("zrychleni:%f\n\r", zrychleni);
            return zrychleni;
}