#include "mbed.h"
#include <SimpleModbus.h>

#define timeout 1000
#define polling 200 // the scan rate
#define retry_count 10
#define TxEnablePin 2
#define LED 13

enum {
    PACKET1,
    PACKET2,
    TOTAL_NO_OF_PACKETS // leave this last entry
};
Packet packets[TOTAL_NO_OF_PACKETS];
packetPointer packet1 = &packets[PACKET1];
packetPointer packet2 = &packets[PACKET2];
unsigned int readRegs[2];
unsigned int writeRegs[2];

void setup()
{
    modbus_construct(packet1, 1, READ_HOLDING_REGISTERS, 0, 2, readRegs);
    modbus_construct(packet2, 1, PRESET_MULTIPLE_REGISTERS, 2, 2, writeRegs);
    modbus_configure(timeout, polling, retry_count, packets, TOTAL_NO_OF_PACKETS);

}

void loop()
{
    modbus_update();

	writeRegs[0] = 255;
//    writeRegs[1] = analogRead(A1); // update data to be written to arduino slave
//
//    if (readRegs[0]==255) digitalWrite(LED, HIGH);
//    else digitalWrite(LED, LOW);

}

int main()
{
    setup();
    while(1) loop();
}
