#include "mbed.h"

InterruptIn button(USER_BUTTON);
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut led(LED1);
int buttonPushCounter = 0;   // counter for the number of button presses

void buttonPressed()
{  
    buttonPushCounter++;
    
    if (buttonPushCounter % 4 == 0) led = 1;
    else led = 0;
    
    pc.printf("number of button pushes: %d.\n", buttonPushCounter);
}

void buttonReleased()
{
    
}

void setup()
{
    button.mode(PullUp);
    pc.baud(9600);
    button.rise(&buttonReleased);  // attach the address of the buttonReleased function to the rising edge
    button.fall(&buttonPressed);  // attach the address of the buttonPressed function to the falling edge
}

void loop()
{
    // put your main code here, to run repeatedly:

}

int main()
{
    setup();
    while(1) loop();
}