#include "mbed.h"

InterruptIn button(USER_BUTTON);
DigitalOut led(LED1);
Timer debounceTimer;
long debounceDelay = 50;
bool debounced = false;

void buttonPressed()
{
    if (debounceTimer.read_ms() > debounceDelay) {
        debounceTimer.stop();
        debounced = false;
    }
    if (debounced == false) {

        led = 1;

        debounceTimer.start();
        debounced = true;
    }
}

void buttonReleased()
{
    if (debounceTimer.read_ms() > debounceDelay) {
        debounceTimer.stop();
        debounced = false;
    }
    if (debounced == false) {

        led = 0;

        debounceTimer.start();
        debounced = true;
    }
}

void setup()
{
    // button.mode(PullUp);
    button.rise(&buttonReleased);  // attach the address of the buttonReleased function to the rising edge
    button.fall(&buttonPressed);  // attach the address of the buttonPressed function to the falling edge
}

void loop()
{
    // put your main code here, to run repeatedly:

}

int main()
{
    setup();
    while(1) loop();
}
