#include "mbed.h"

DigitalOut myled(LED1);  // Assign LED1 output port
time_t previousSeconds;
long interval = 1;

void setup()
{
    // setup time structure for 26 August 2014 00:00:00
    struct tm t;
    t.tm_sec = 00;    // 0-59
    t.tm_min = 00;    // 0-59
    t.tm_hour = 00;   // 0-23
    t.tm_mday = 26;   // 1-31
    t.tm_mon = 8;     // 0-11
    t.tm_year = 114;  // year since 1900
    
    time_t seconds = mktime(&t);
    set_time(seconds);
    previousSeconds = seconds;
}

void loop()
{
    time_t currentSeconds = time(NULL);
    if(currentSeconds - previousSeconds > interval) {
        previousSeconds = currentSeconds; // save the last time you blinked the LED
        myled = !myled;
    }
}

int main()
{
    setup();
    while(1) loop();
}


