#include "mbed.h"

Serial pc(SERIAL_TX, SERIAL_RX);
AnalogIn mySensor(A0);

// the setup routine runs once when you press reset:
void setup()
{
    pc.baud(9600);
}

// the loop routine runs over and over again forever:
void loop()
{
    uint16_t sensorValue = mySensor.read_u16(); // Converts and read the analog input value
    pc.printf("%d\n", sensorValue);
    wait(0.1);
}

int main()
{
    setup();
    while(1) loop();
}