// EdgeCounter on mbed
//
// Counts falling edges on p5.
// Used as test setup for interfacing a hall sensor to our water/gas sensor.
//
// Whenever the hall sensor triggers, edgecount is incremented and the
// current value is transmitted to the serial port.
//
// Any character sent to the serial port returns the current count value
//
// Written by Lieven Hollevoet

#include "mbed.h"

// Create objects
Serial pc(USBTX, USBRX);
DigitalOut status(LED4);
DigitalOut count(LED2);
InterruptIn sensor(p5);

int edgecount;

void ISR_serial(void) {
    
    char tmp = pc.getc();
    status = 1;
    
    pc.printf("Current edge count is %i\r\n", edgecount);
    status = 0;
}

void falling_edge(void){
    edgecount++;
    count = 1;
    pc.printf("Falling edge, count is %i!\r\n", edgecount);
    count = 0;
}

int main() {

    count     = 0;
    edgecount = 0;
    
    pc.printf("Edgecounter started");

    // Attach interrupt handlers
    pc.attach(&ISR_serial);
    sensor.fall(&falling_edge);
    
}

