
#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl16.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

void CommandHandler();

AnalogInHL2 ls1(P1_9), ls2(P0_23), ls3(P0_16), ls4(P0_15), ls5(P1_3);

int main(void)
{
    // MainPow und LineSensor einschalten
    boardPow = 3;
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200); // 115200
    ua0.SvMessage("LineSensTest_13"); // Meldung zum PC senden
    AllLedsOff();

    Timer stw;
    stw.start();
    while(1) {
        CommandHandler();
        if( (stw.read_ms()>10) ) { // 100Hz
            // dieser Teil wird mit 100Hz aufgerufen
            stw.reset();
            if( ua0.acqON ) {
                // nur wenn vom PC aus das Senden eingeschaltet wurde
                // wird auch etwas gesendet
                ua0.WriteSvI16(1, ls1.Read());
                ua0.WriteSvI16(2, ls2.Read());
                ua0.WriteSvI16(3, ls3.Read());
                ua0.WriteSvI16(4, ls4.Read());
                ua0.WriteSvI16(5, ls5.Read());
            }
        }
    }
    return 1;
}

void CommandHandler()
{
    uint8_t cmd;
    // Fragen ob �berhaupt etwas im RX-Reg steht
    if( !pc.IsDataAvail() )
        return;
    // wenn etwas im RX-Reg steht
    // Kommando lesen
    cmd = ua0.GetCommand();
    
    if( cmd==2 ) {
        mL.SetPow2(ua0.ReadF()); mR.SetPow2(ua0.ReadF());
    ua0.SvMessage("Set Pow");
  }
}

















