#include "mbed.h"

//              main=1 LS=2  ENC=4
BusOut boardPow(P2_13, P2_5, P2_2); // B16/17

DigitalOut LedFL1(P1_10); // D1
DigitalOut LedFL2(P1_11); // D2
DigitalOut LedFR1(P1_12); // D4
DigitalOut LedFR2(P1_13); // D5

DigitalOut LedBL1(P1_14); // D6
DigitalOut LedBL2(P1_15); // D7
DigitalOut LedBR1(P1_16); // D8
DigitalOut LedBR2(P1_17); // D9

DigitalOut LedD10(P1_18); DigitalOut LedD11(P2_16); DigitalOut LedD12(P1_20);
DigitalOut LedD13(P1_21);

// Links / Rechts wenn man von hinten auf den Bertl draufschaut
DigitalIn BtnBM(P1_26); //TA4
DigitalIn BtnBR(P1_28); //TA6
DigitalIn BtnBL(P1_27); //TA5

DigitalIn BtnFM(P1_23); //TA1 
DigitalIn BtnFR(P1_24); //TA2
DigitalIn BtnFL(P1_25); //TA3
DigitalIn BtnFRR(P1_30); //TA7
DigitalIn BtnFLL(P1_31); //TA8

DigitalIn xx1(P2_8), xx2(P2_9); // the useless Encoder-Inputs


int GetPin(PinName aName)
{
  return (aName >> PIN_SHIFT) & 0x0000003F;
}

int GetPort(PinName aName)
{
  return (aName >> PORT_SHIFT) & 0x0000003F;
}


class Motor {
	public:
		Motor(PinName pwm, PinName fwd, PinName rev);
    void SetBrake(int aOnOff);
		void SetPow(float aPow);
    void SetPow2(float aPow);
	protected:
    PwmOut _pwm;
    DigitalOut _fwd;
    DigitalOut _rev;
    int16_t    _running;
};

Motor mL(P1_19,P2_15,P2_14); Motor mR(P2_19,P2_20,P2_21);

Motor::Motor(PinName pwm, PinName fwd, PinName rev) :
_pwm(pwm), _fwd(fwd), _rev(rev) 
{
	_pwm.period(0.001); _pwm=0;
	_fwd=0; _rev=0; _running=0;
}

void Motor::SetBrake(int aOnOff)
{
  _pwm=0;
  if( aOnOff )
    { _fwd=0; _rev=0; }
  else
    { _fwd=1; _rev=1; }
}

void Motor::SetPow(float aPow)
{
	if( aPow==0 ) {
    _pwm=0; _running=0; return;
  }
	if( aPow>=0.0 ) {
		_fwd=1; _rev=0;
		_pwm = aPow;
	}
	else {
		_fwd=0; _rev=1;
		_pwm = -aPow;
	}
	_running=1;
}

void Motor::SetPow2(float aPow)
{
  float pow;
  if( aPow==0 ) {
    _pwm=0; _running=0; return;
  }
	if( aPow>=0.0 ) {
		_fwd=1; _rev=0;
		pow = aPow;
	}
	else {
		_fwd=0; _rev=1;
		pow = -aPow;
	}
  if( !_running && (pow<0.3) ) {
    _pwm = 0.3;
    wait_ms(20); // 50
  }
  _pwm = pow;
  _running = 1;
}


void AllLedsOff()
{
  LedFL1=1;
  LedFL2=LedFR1=LedFR2=LedBL1=LedBL2=LedBR1=LedBR2=1;
  LedD10=LedD11=LedD12=LedD13=1;
}


/* DigitalInHL public DigitalIn {
  public:
    DigitalInHL(PinName pin) : DigitalIn(pin) {}

    int MultiCheck(int aState=0)
    {
      int cnt=0;
      for(int i=1; i<=10; i++)
	    {
		    if( read()==aState )
			    cnt++;
      }
      if( cnt>=10 )
        return 1;
      return 0;
    }
}; */


class AnalogInHL2 : public AnalogIn {
  public:
    AnalogInHL2(PinName pin) : AnalogIn(pin) {}
    int Read()
			{ return read_u16()>>4; }
};





