
#include "mbed.h"
#include "Bertl16.h"

void ForewardUntilWall();

void BackwardUntilWall();

int MultiCheckBtn(DigitalIn& aBtn);

void FwBlinker();
void BwBlinker();

Timer t1;

int main(void)
{
  boardPow=1;
  AllLedsOff();
  t1.start();
  
  while( !MultiCheckBtn(BtnFM) ) 
	{
	}

  while(1)
  {
    // BtnTest();
    ForewardUntilWall();
    BackwardUntilWall();
  }
  
  return 1;
}


void ForewardUntilWall()
{
  LedFL1 = LedFR1 = 0;
  mL.SetPow(0.3); mR.SetPow(0.3);
  while( 1 )
  {
    if( MultiCheckBtn(BtnFM) || MultiCheckBtn(BtnFL) || MultiCheckBtn(BtnFR) )
      break;
    FwBlinker();
  }
  mL.SetPow(0.0); mR.SetPow(0.0);
  LedFL1 = LedFR1 = 1;
}

void FwBlinker()
{
  if( t1.read_ms()<100 )
    return;
  t1.reset();
  LedFL1 = !LedFL1;
  LedFR1 = !LedFR1;
}

void BackwardUntilWall()
{
  LedBL1 = LedBR1 = 0;
  mL.SetPow(-0.3); mR.SetPow(-0.3);
  while( 1 )
  {
    if( MultiCheckBtn(BtnBL) || MultiCheckBtn(BtnBM) || MultiCheckBtn(BtnBR) )
      break;
    BwBlinker();
  }
  mL.SetPow(0.0); mR.SetPow(0.0);
  LedBL1 = LedBR1 = 1;
}

void BwBlinker()
{
  if( t1.read_ms()<100 )
    return;
  t1.reset();
  LedBL1 = !LedBL1;
  LedBR1 = !LedBR1;
}


int MultiCheckBtn(DigitalIn& aBtn)
{
	int cnt=0;
	for(int i=1; i<=10; i++)
	{
		if( aBtn.read()==0 )
			cnt++;
	}
	if( cnt>=10 )
		return 1;
	return 0;
}
















