#include "mbed.h"
#include "Serial_HL.h"
#include "BtnEventM0.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

BusOut leds(LED1,LED2,LED3,LED4); // Bertl14

//              main=2^0  LS    ENC2^11
BusOut boardPow(p30,      P1_6, P1_7);

void CommandHandler();

// ls5 nur beim Betrl15
// AnalogInHL ls1(p18), ls2(p16), ls3(p19), ls4(p17); // B14

AnalogInHL ls1(p18), ls2(p16), ls3(p20), ls4(p19), ls5(p17); // B15

int main(void)
{
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200); // 115200
    leds = 9;
    boardPow = 3;
    ua0.SvMessage("LineSensTest_5"); // Meldung zum PC senden

    Timer stw;
    stw.start();
    while(1) {
        CommandHandler();
        if( (stw.read_ms()>10) ) { // 100Hz
            // dieser Teil wird mit 100Hz aufgerufen
            stw.reset();
            if( ua0.acqON ) {
                // nur wenn vom PC aus das Senden eingeschaltet wurde
                // wird auch etwas gesendet
                ua0.WriteSvI16(1, ls1.Read());
                ua0.WriteSvI16(2, ls2.Read());
                ua0.WriteSvI16(3, ls3.Read());
                ua0.WriteSvI16(4, ls4.Read());
                ua0.WriteSvI16(5, ls5.Read());
            }
        }
    }
    return 1;
}

void CommandHandler()
{
    uint8_t cmd;
    int16_t idata1, idata2;

    // Fragen ob überhaupt etwas im RX-Reg steht
    if( !pc.IsDataAvail() )
        return;

    // wenn etwas im RX-Reg steht
    // Kommando lesen
    cmd = ua0.GetCommand();

    if( cmd==2 ) {
        // cmd2 hat 2 int16 Parameter
        idata1 = ua0.ReadI16();
        idata2 = ua0.ReadI16();
        // für die Analyse den Wert einfach nur zum PC zurücksenden
        ua0.SvPrintf("Command2 %d %d", idata1, idata2);
    }
    if( cmd==3 ) {
        idata1 = ua0.ReadI16();
        leds = idata1;
        ua0.SvMessage("Leds schalten");
    }
    if( cmd==4 ) {
        idata1 = leds;
        ua0.SvPrintf("LEDS %d", idata1);
    }
}


