#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

void CommandHandler();

//              main=2^0  LS    ENC 2^2
BusOut boardPow(p30,      P1_6, P1_7);

int main(void)
{
    boardPow=1;
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200);
    InitBertl();
    pex.useISR=0;
    leds=9;
    wait(1.0);
    leds=6;

    ua0.SvMessage("DistSensTest_4");

    Timer stw;
    stw.start();
    while(1) {
        CommandHandler();
        if( ua0.acqON && (stw.read_ms()>10) ) {
            stw.reset();
            if( ua0.acqON ) {
                us.StartMeas(); // for next cycle
                ua0.WriteSvI16(1, us.distCM*100.0);
            }
        }
    }
    return 1;
}

void CommandHandler()
{
    uint8_t cmd;
    if( !pc.IsDataAvail() )
        return;
    cmd = ua0.GetCommand();
}

