
#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

int gBlinkMode = 1;
void BlinkTask();
Timer stw;

int main(void)
{
    InitBertl();
    pex.useISR=0; leds=9;
    pex.ClearLeds();
    
    pex.WaitUntilButtonPressed();
    leds=6; wait(0.8);
    pex.WaitUntilButtonPressed();
    leds=0;
    stw.start();
    while(1) {
        pex.ReadButtons();
        if( pex.IsButton(BTN_FLL) ) {
            gBlinkMode=1; pex.ClearLeds();
            mL.SetPow(0.2); mR.SetPow(0.9); 
        }
        else if( pex.IsButton(BTN_FRR) ) {
            gBlinkMode=2; pex.ClearLeds();
            mL.SetPow(0.9); mR.SetPow(0.2);
        }
        else if( pex.IsAnyFrontButton() ) {
            gBlinkMode=4; pex.ClearLeds();
            mL.SetPow(-0.9); mR.SetPow(-0.9);
        }
        else if( pex.IsAnyBackButton() ) {
            gBlinkMode=3; pex.ClearLeds();
            mL.SetPow(0.9); mR.SetPow(0.9);
        }
        // Blink dependent on value of gBlinkMode
        BlinkTask();
        wait(0.005);
    }
    
    return 1;
}

void BlinkTask()
{
    if( stw.read_ms()<200 )
        return;
    stw.reset();
    if( gBlinkMode==1 )
        pex.ToggleLeds(LED_FL1);
    if( gBlinkMode==2 )
        pex.ToggleLeds(LED_FR1);
    if( gBlinkMode==3 )
        pex.ToggleLeds(LED_ALL_FRONT);
    if( gBlinkMode==4 )
        pex.ToggleLeds(LED_ALL_BACK);
}
