#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

// V 3.1

SerialBLK pc(USBTX, USBRX);
// SerialBLK pc(p9, p10); // BlueTooth
SvProtocol ua0(&pc);

//              main=2^0  LS    ENC 2^2
BusOut boardPow(p30,      P1_6, P1_7);

void CommandHandler();
void SwitchLeds();

int main(void)
{
    boardPow=1;
    wait_ms(10);
    InitBertl();
    pex.useISR=0;
    leds=0;
    pex.ClearLeds();
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200); // 115200
    ua0.SvMessage("BertlKart_1");

    Timer stw;
    stw.start();
    while(1) {
        CommandHandler();
        if( (stw.read_ms()>10) ) {
            SwitchLeds();
            stw.reset();
            if( ua0.acqON ) {
                ua0.WriteSvI16(1, mL.encCnt);
                ua0.WriteSvI16(2, mR.encCnt);
            }
        }
    }
    return 1;
}

int16_t ledsOn = 0;
void SwitchLeds()
{
    pex.ReadButtons();
    if( pex.IsAnyBackButton() ) {
        if( ledsOn ) {
            pex.ClearLeds();
            ledsOn=0;
        } else {
            pex.SetLedPort(LED_BR2|LED_BL1);
            ledsOn=1;
        }
        wait_ms(500);
    }
}

void CommandHandler()
{
    uint8_t cmd;
    if( !pc.IsDataAvail() )
        return;
    cmd = ua0.GetCommand();

    if( cmd==2 ) {
        if( ua0.ReadI16() )
            pex.SetLedPort(LED_BR2|LED_BL1);
        else
            pex.ClearLeds();
    }
    if( cmd==3 ) { // Rev. Brake
        int16_t dir = pc.GetChar();
        if( dir>0 ) { // 1 Brake for Forw.
            mL.SetPow(-0.3);
            mR.SetPow(-0.3);
        } else { // 0 Brake for Backw.
            mL.SetPow(0.3);
            mR.SetPow(0.3);
        }
        wait_ms(50);
        mL.SetPow(0);
        mR.SetPow(0);
        ua0.SvMessage("Rev Brake");
    }
    if( cmd==4 ) {
        mL.SetPow2(ua0.ReadF());
        mR.SetPow2(ua0.ReadF());
    }
    if( cmd==5 ) {
        mL.SetPow(ua0.ReadF());
        mR.SetPow(ua0.ReadF());
    }
}


