#include "mbed.h"
#include "TLV320HL.h"

const float F_SAMPLE = 32000.0;
const float F_SAMPLE_IST = 31251;

//           tx_sda tx_ws clk rx_sda rx_ws
I2SSlave i2s(p5,    p6,   p7, p8,    p29);
//         sda scl  addr
TLV320 tlv(p9, p10, 52, &i2s);

void I2S_ISR();

int main()
{
    tlv.Init(F_SAMPLE);
    i2s.attach(&I2S_ISR);
    i2s.Start();
    while(1) {
    }
}

void I2S_ISR()
{
    int32_t left, right;
    // for(int i=1; i<=1; i++) 32kHz ISR-Load
    // for(int i=1; i<=8; i++) 4kHz ISR-Load
    for(int i=1; i<=8; i++) {
        i2s.Read(&left, &right);
        // Do DSP
        i2s.Write(left, left);
    }
}


