#include "mbed.h"
// receive a line from a stream, allowing backspace editing,
// and checking for buffer overflow. Terminates on either a \n or \r.
size_t getline(Stream &s, char *buf, size_t bufsize)
{
    char c;
    size_t receivedChars = 0;
    for(;;)
    {
        c = s.getc();
        if (c == '\r' || c == '\n')
            break;
        s.putc(c);
        if (c == '\b')
        {
            if (receivedChars > 0)
            {
                buf--;
                receivedChars--;
            }
        }
        else if (receivedChars < bufsize - 1)
        {
            *buf++ = c;
            receivedChars++;
        }
    }
    *buf++ = 0;
    s.putc('\n');
    s.putc('\r');
    return receivedChars;
}