#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "fiap.h"

#define NtpServer "ntp.nict.jp"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

EthernetInterface eth;
NTPClient ntp;
//FIAP fiap("http://192.168.1.5/axis2/services/FIAPStorage","http://test.fiap.org/mbed_hello/");
FIAP fiap("http://192.168.1.3/axis2/services/FIAPStorage");

char timezone[] = "+09:00";  // JST

struct fiap_element element[]= {
    {"P1",NULL,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
    {"P2",NULL,NULL,NULL,NULL,NULL,NULL,NULL,timezone},
};

//struct fiap_element element[]={
//    {"P1",NULL,NULL,timezone},
//    {"P2",NULL,NULL,timezone},
//};

int main() {
    led1=led2=led3=led4=0;
    fiap.debug_mode=true;
    //EthernetNetIf initialize
//    EthernetErr ethErr = eth.setup();
    eth.init(); //Use DHCP
    eth.connect();
    //if (ethErr) {
        //   lcd.locate(0,1);
        //   lcd.printf("Error %d in setup.\n", ethErr);
    //    return -1;
    //}
    led1=1;
    //NTPClient initia,lize
    //Host server(IpAddr(), 123, ntp_server);
    //NTPResult Ntpr=ntp.setTime(server);
    ntp.setTime(NtpServer);
    //UTC-->JST +9Hour(32400Sec)
    time_t ctTime;
    ctTime = time(NULL);
    ctTime+=32400;
    set_time(ctTime);
    led2=1;

    //post
    int i,j;
    for (j=0; j<10; j++) {
        //data initialize
        time_t seconds = time(NULL);
        for (i=0; i<2; i++) {
        char data[5];
            int s=j*pow((double)10,i);
            sprintf(data,"%03d",s);
            element[i].value=data;
    struct tm t = *localtime(&ctTime);
    element[0].year=t.tm_year+1900;
    element[0].month=t.tm_mon+1;
    element[0].day=t.tm_mday;
    element[0].hour=t.tm_hour;
    element[0].minute=t.tm_min;
    element[0].second=t.tm_sec;
    fiap.post(element,1);
//                element[i].t=localtime(&seconds);
        }
        //do post
        int ret=fiap.post(element,2);
        if(ret!=0){
        while (1) {
        led3=!led3;
        wait(0.5);
    }
        return 0;
        }
        wait(1);
    }
    //finish
    while (1) {
        led4=!led4;
        wait(0.5);
    }
}
