#include "mbed.h"
#include "NewTextLCD.h"
DigitalOut rs(D12);
DigitalOut e(D11);
DigitalOut d0(D10);
DigitalOut d1(D9);
DigitalOut d2(D8);
DigitalOut d3(D7);
DigitalOut d4(D6);
DigitalOut d5(D5);
DigitalOut d6(D4);
DigitalOut d7(D3);

void write_data_to_port(uint8_t data)
{
    d0=((data>>0)& 0x01);
    d1=((data>>1)& 0x01);
    d2=((data>>2)& 0x01);
    d3=((data>>3)& 0x01);
    d4=((data>>4)& 0x01);
    d5=((data>>5)& 0x01);
    d6=((data>>6)& 0x01);
    d7=((data>>7)& 0x01);
}
void send_data(uint8_t data)
{
    rs=1;
    write_data_to_port(data);
    e=1;
    wait(0.04f);
    e=0;
}

void send_command(uint8_t command)
{
    rs=0;
    write_data_to_port(command);
    e=1;
    wait(0.04f);
    e=0;
}

void init_lcd(void)
{
    wait(0.02f);
    send_command(0b00110000);
    send_command(0b00110000);
    send_command(0b00110000);
    send_command(0b00111000);
    send_command(0b00001111);
    send_command(0b00000001);
    send_command(0b00000110);
    send_command(0b00000010);
}

void lcd_set_address(uint8_t address)
{
    send_command(0b10000000 | address);
}

void write_string(char * str)
{
    do {
        send_data(*str);
    } while (*++str);
}

void clear_string()
{
   int clear=80;
   
   for(int i=0; i<(clear);i++){
       write_string(" ");
       }
}



int main()
{
   
    init_lcd();
    while(1){
    write_string("405 A");
    clear_string();
    for(int i=0; i<6;i++){
    write_string(" ");
    }
    write_string("405 A");
    clear_string();
    for(int i=0; i<19;i++){
    write_string(" ");
    }
    write_string("405 A");
    clear_string();
    }
}
