#include "xyz_sensor_platform.h"

XYZSensorPlatform::XYZSensorPlatform():
    xZero(MOTOR_X_PINT_ZERO),
    xEnd(MOTOR_X_PINT_END),
    yZero(MOTOR_Y_PINT_ZERO),
    yEnd(MOTOR_Y_PINT_END),
    zZero(MOTOR_Z_PINT_ZERO),
    zEnd(MOTOR_Z_PINT_END),
    _movedTimes(0)
{
    motorX = new CD_2D34M("motorX\0", \
                          MOTOR_X_POUT_DIRECTION, \
                          MOTOR_X_POUT_PULSE, \
                          MOTOR_X_PINT_ALARM, \
                          MOTOR_X_POUT_RESET);
    motorY = new CD_2D34M("motorY\0", \
                          MOTOR_Y_POUT_DIRECTION, \
                          MOTOR_Y_POUT_PULSE, \
                          MOTOR_Y_PINT_ALARM, \
                          MOTOR_Y_POUT_RESET);
    motorZ = new CD_2D24MB("motorZ\0", \
                           MOTOR_Z_POUT_PU, \
                           MOTOR_Z_POUT_DR, \
                           MOTOR_Z_POUT_MF);
    sensor = Pololu5Mag::Instance();
    gyroscope = sensor->gyroArray(0);
    accelerometer = sensor->motionArray(0);
    magnetometer = sensor->magneticArray(0);
    temp_sensor = sensor->tempArray(0);
    init();
}
void XYZSensorPlatform::init(void)
{
    uint8_t id1, id2;

    /* Determine ID of Gyro & Motion Sensor */
    CALL_METH(gyroscope, read_id, &id1, 0x0);
    CALL_METH(accelerometer, read_id, &id2, 0x0);
    printf("\r\ngyr_addr: %p, accer_addr: %p\r\n",gyroscope,accelerometer);
//#ifdef MOTOR_INITIAL
    
//#endif
}    
void XYZSensorPlatform::reset() {
    /** Motor Initial **/
    _movedTimes = 0;
    x = 1;
    y = 1;
    z = 1;
    int step = 0;
    while(xEnd!=0 && step++ < 10)
    {
        go_right();
        _movedTimes = 0;
    }
    while(xZero!=0) {
        go_left();
        _movedTimes = 0;
        wait(0.01);
    }
    go_right();
    step = 0;
    while(yEnd!=0 && step++ < 10) go_forward();
    while(yZero!=0 && yZero != 0) {
        go_backward();
        _movedTimes = 0;
        wait(0.01);
    }
    go_forward();
    step = 0;
    while(zEnd!=0 && step++ < 10) go_up();
    while(zZero!=0) {
        go_down();
        _movedTimes = 0;
        wait(0.01);
    }
    go_up();
    motorX->reset();
    motorY->reset();
    motorZ->reset();
}

void XYZSensorPlatform::go_forward()
{
    checkMovedTimes();
    if(yEnd == 1) motorY->go(MOTOR_SIDE);
}

void XYZSensorPlatform::go_backward()
{
    checkMovedTimes();
    if(yZero == 1) motorY->go(NON_MOTOR_SIDE);
}

void XYZSensorPlatform::go_up()
{
    checkMovedTimes();
    if(zEnd == 1) motorZ->go(MOTOR_SIDE);
}

void XYZSensorPlatform::go_down()
{
    checkMovedTimes();
    if(zZero == 1) motorZ->go(NON_MOTOR_SIDE);
}

void XYZSensorPlatform::go_right()
{
    checkMovedTimes();
    if(xEnd == 1) motorX->go(MOTOR_SIDE);
}

void XYZSensorPlatform::go_left()
{
    checkMovedTimes();
    if(xZero == 1) motorX->go(NON_MOTOR_SIDE);
}
void XYZSensorPlatform::to(float x, float y, float z)
{
    checkMovedTimes();
    float pos[3];
    position(pos);
    if(pos[2] > z) {
        if(zZero == 1) motorZ->to(z);
    } else if(zEnd == 1) motorZ->to(z);
    if(pos[0] > x) {
        if(xZero == 1) motorX->to(x);
    } else if(xEnd == 1) motorX->to(x);
    if(pos[1] > y) {
        if(yZero == 1)motorY->to(y);
    } else if(yEnd == 1) motorY->to(y);
}

void XYZSensorPlatform::checkMovedTimes()
{
    if(_movedTimes++>=CALIBRATION_TIME)
    {
        float p[3] = {0.0};
//        position(p);
        reset();
//        to(p[0],p[1],p[2]);
//        _movedTimes = 0;
    }
}
