#ifndef ParseArray_h
#define ParseArray_h


#include <string>
using namespace std;
typedef unsigned char byte;
class ParseArray
{

public :
    //header
    bool hasHeader;
    int headerIndex;
    int headerLength;
    byte* headerValue;
    string headerValueTmp;
    // current header index
    int currentHeaderIndex;
    // Footer
    bool hasFooter;
    int footerIndex;
    int footerLength;
    byte* footerValue;
    string footerValueTmp;
    // current footer index
    int currentFooterIndex;
    // check
    // CRC
    bool hasCRC;
    int checkCRCIndex;
    int checkCRCLength;
    // check xorValue
    bool hasCheckXOR;
    int  checkXORIndex;
    // length
    bool lengthFix;
    int length;

    // index
    int currentIndex;

    // array
    byte* bufferArray;
    int bufferLength;
    byte* dataArray;

    // constructor
    ParseArray();
    // string to byte function
    byte* stringToByte(string hex, int length);
    // buffer setting
    void setBufferValue(byte* buf, int lengthTmp, int checkSumStart);
    void setBufferValueAdjustFooterIndex(byte* buf, int buflength, int checkSumStart);
    void setBufferValue(byte* buf,int lengthTmp);

    // header
    void enableHeader(int headerindex, int headerlength, string headervalue);
    // footer
    void enableFooter(int footerindex, int footerlength, string footervalue);
    // crc
    void enableCRC(int crcindex, int crclength);
    // xorValue
    void enableCheckXOR(int xorindex);

    // check Header
    bool testHeader(int hindex) ;
    // check Footer
    bool testFooter(int findex);
    // test XOR // set xindex as headerIndex
    bool testXOR(int hindex);
    // parsing
    bool parse(int curIndex);
    // compute xor
    byte computeXOR(byte t1[], int len);


};



#endif

