#ifndef __MOTOR_H
#define __MOTOR_H

#include "mbed.h"
//#define ALARM
#define MOTOR_SIDE 1
#define NON_MOTOR_SIDE 0
#define CD_2D34M__TxCM_S 625.0
#define CD_2D24MB__TxCM_S 125.0
#define CD_2D34M__CW 1
#define CD_2D24MB__CW 0

class Motor
{
public:
    Motor(PinName p, PinName d, PinName e, char* n, float Tcs, int cw/*, InterruptIn *c, InterruptIn *cc*/);
// p_us = signal period in micro_seconds
// dc   = signal duty-cycle (0.0 to 1.0)
    void pwm_io(int p_us, float dc); // not used...
    void go(int direction);
    void setSpeed(float cm_s);
    float speed() {
        return (float)_TXcm_s/(_onDelay+_offDelay);
    }
    void reset() {
        if(_lock){
            return;
        }
        _pos=0;
    }
    void to(float p);
    float position() {
        if(_lock){
            return -1;
        }
        return _pos;
    }
    bool moving(){ return _lock; }
    void setPosition(float p) {
        if(_lock){
            return;
        }
        _pos = p;
    }
    void stop(void);
protected:
    void toggleOn(void);
    void toggleOff(void);
    void rotateCallBack(void);
    Timeout _pulseTimeout, _rotateTimeout;
    DigitalOut _pulse, _dir, _error;
    int _onDelay;
    int _offDelay;
    float _TXcm_s;
    char* _name;
    float _pos, _goal;
    int _cw,_ccw;
    bool _lock;
//    InterruptIn *_clockStop, *_counterClockStop;
};

class CD_2D34M: public Motor
{
public:
    CD_2D34M(char* n, PinName d, PinName p, PinName a, PinName e);
private:
    void alarm_event();
    void alarm_reset();
    InterruptIn alarm;
};

class CD_2D24MB: public Motor
{
public:
    CD_2D24MB(char* n, PinName p, PinName d, PinName e);

};

#endif // __MOTOR_H
