#include "motor.h"

Motor::Motor(PinName p, PinName d, PinName e, char* n, float Tcs, int cw/*, InterruptIn *c, InterruptIn *cc*/):
    _pulse(p),
    _dir(d),
    _error(e),
    _TXcm_s(Tcs),
    _name(n),
    _cw(cw),
    _ccw(1-cw),
    _lock(false)/*,
    _clockStop(c),
    _counterClockStop(cc)*/
{
    _pulse = 0;
    _dir = 0;
    _error = 1;
    _pos = 0;
    setSpeed(1);
}

void Motor::pwm_io(int p_us, float dc)
{
    _pulseTimeout.detach();
    if ((p_us == 0) || (dc == 0)) {
        return;
    }
    if (dc >= 1) {
        return;
    }
    _pulse = 0;
    _dir = 0;
    _error = 1;
    _onDelay = (int)(p_us * dc);
    _offDelay = p_us - _onDelay;
    printf("on delay: %dus\r\n_offDelay: %dus\r\n", _onDelay, _offDelay);
    toggleOn();
}

void Motor::toggleOn(void)
{
//    core_util_critical_section_enter();
    _pulse = 1;
//    if(*_clockStop == 0 || *_counterClockStop == 0) return;
    _pulseTimeout.attach_us(this, &Motor::toggleOff, _onDelay);
//    core_util_critical_section_exit();
}

void Motor::toggleOff(void)
{
//    core_util_critical_section_enter();
    _pulse = 0;
    _pulseTimeout.attach_us(this, &Motor::toggleOn, _offDelay);
//    core_util_critical_section_exit();
}

void Motor::stop(void)
{
//    core_util_critical_section_enter();
    _pulseTimeout.detach();
    _rotateTimeout.detach();
    _lock=false;
//    core_util_critical_section_exit();
}
void Motor::go(int direction)
{
//    core_util_critical_section_enter();
    if(_lock) {
        return;
    }
    _lock=true;
    _pulseTimeout.detach();
    _pulse = 0;
    _dir = (direction?_ccw:_cw);
    _error = 1;
    wait(0.001);
//    core_util_critical_section_exit();
    toggleOn();
    wait(0.1);
//    _rotateTimeout.attach(callback(this,&Motor::rotateCallBack), 0.1);
//    core_util_critical_section_enter();
    float d=speed()*0.1;
    if(direction == MOTOR_SIDE) _pos += d;
    else _pos -= d;
    _pulseTimeout.detach();
    _lock=false;
//    core_util_critical_section_exit();
}

void Motor::to(float p)
{
//    core_util_critical_section_enter();
    if(_lock) {
        return;
    }
    if (p==_pos) return;
    _lock=true;
    _goal = p;
    float time=(p-_pos)/speed();
    int direction=(time>0)?MOTOR_SIDE:NON_MOTOR_SIDE;
    if(time<0) time=-time;
    _pulseTimeout.detach();
    _pulse = 0;
    _dir = (direction?_ccw:_cw);
    _error = 1;
    wait(0.001);
//    core_util_critical_section_exit();
    toggleOn();
    
    //wait(time);
    _rotateTimeout.attach(callback(this, &Motor::rotateCallBack), time);
//    core_util_critical_section_enter();
//    _pulseTimeout.detach();
//    _pos=p;
//    _lock=false;
//    core_util_critical_section_exit();
//    _goal=p;
//    _pulseTimeout.attach(this, &Motor::reach_goal, time);
}

void Motor::setSpeed(float cm_s)
{
    if(_lock) {
        return;
    }
    _lock=true;
    float T=_TXcm_s/cm_s;
    _onDelay=(int)T/2;
    _offDelay=T-_onDelay;
    _lock=false;
}

void Motor::rotateCallBack(void)
{
    _pulseTimeout.detach();
    _pos = _goal;
    _lock = false;
    _goal = 0;
}

CD_2D34M::CD_2D34M(char* n, PinName d, PinName p, PinName a, PinName e/*, InterruptIn *c, InterruptIn *cc*/):
    Motor(p,d,e,n,CD_2D34M__TxCM_S,CD_2D34M__CW/*, c, cc*/), alarm(a)
{
#ifdef ALARM
    alarm.fall(this, &CD_2D34M::alarm_event);
#endif
    //alarm.fall(this, &CD_2D34M::alarm_reset);
}
void CD_2D34M::alarm_event()
{
    _error = 0;
    wait(0.01);
    alarm_reset();
}
void CD_2D34M::alarm_reset()
{
    _error = 1;
    wait(0.01);
}

CD_2D24MB::CD_2D24MB(char* n, PinName p, PinName d, PinName e/*, InterruptIn *c, InterruptIn *cc*/):
    Motor(p,d,e,n,CD_2D24MB__TxCM_S,CD_2D24MB__CW/*, c, cc*/)
{}