#ifndef __XYZ_SENSOR_PLATFORM_H
#define __XYZ_SENSOR_PLATFORM_H

/*** Includes ----------------------------------------------------------------- ***/
//#include "mbed.h"
#include "altimu_10_v5.h"
#include "motor.h"
#include "motor_targets.h"
#define MOTOR_INITIAL
#define CALIBRATION_TIME 100

/*** Typedefs ----------------------------------------------------------------- ***/
typedef struct {
    int32_t AXIS_X;
    int32_t AXIS_Y;
    int32_t AXIS_Z;
} AxesRaw_TypeDef;

class XYZSensorPlatform
{
public:
    XYZSensorPlatform();
    void init(void);
    void reset(void);
    
    void go_forward();
    void go_backward();
    void go_up();
    void go_down();
    void go_right();
    void go_left();
    
    bool isMoving(){ return motorX->moving() || motorY->moving() || motorZ->moving(); }
    
    void set_speed(float speed) {
        motorX->setSpeed(speed);
        motorY->setSpeed(speed);
        motorZ->setSpeed(speed);
    }
    
    float speed() {
        return motorX->speed();
    }
    
    void position(float* pos) {
        pos[0] = motorX->position();
        pos[1] = motorY->position();
        pos[2] = motorZ->position();
    }
    
    void setPosition(float x, float y, float z) {
        motorX->setPosition(x);
        motorY->setPosition(y);
        motorZ->setPosition(z);
    }
        
    
    void to(float x, float y, float z) ;

    AxesRaw_TypeDef get_mag() {
        AxesRaw_TypeDef ret;
        magnetometer->get_m_axes((int32_t *)&ret);
        return ret;
    }
    
    int get_mag_raw(int16_t *ret) {
        return magnetometer->get_m_axes_raw(ret);
    }
    
    AxesRaw_TypeDef get_acc() {
        AxesRaw_TypeDef ret;
        accelerometer->get_x_axes((int32_t *)&ret);
        return ret;
    }
    
    AxesRaw_TypeDef get_gyr() {
        AxesRaw_TypeDef ret;
        gyroscope->get_g_axes((int32_t *)&ret);
        return ret;
    }
    
    void setSensorI2cFrequency(int hz){ sensor->setI2cFrequency(hz); }
private:
    void checkMovedTimes();
    Motor *motorX, *motorY, *motorZ;
    float x,y,z;
    int _movedTimes;
    InterruptIn xZero, xEnd, yZero, yEnd, zZero, zEnd;
    AltIMU_10_v5 *sensor;
    GyroSensor *gyroscope;
    MotionSensor *accelerometer;
    MagneticSensor *magnetometer;
    TempSensor *temp_sensor;
};
#endif // __XYZ_SENSOR_PLATFORM_H