/**
  ******************************************************************************
  * @file    altimu_10_v5_targets.h
  * @author  AST / EST
  * @version V0.0.1
  * @date    14-April-2015
  * @brief   This header file is intended to manage the differences between 
  *          the different supported base-boards which might mount the
  *          MOTOR MEMS Inertial & Environmental Nucleo Expansion Board.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */ 

/* Define to prevent from recursive inclusion --------------------------------*/
#ifndef _MOTOR_TARGETS_H_
#define _MOTOR_TARGETS_H_

/** Motor X**/
#define MOTOR_X_POUT_DIRECTION               (D0)
#define MOTOR_X_POUT_PULSE                   (D1)
#define MOTOR_X_PINT_ALARM                   (D2)   // PF_15
#define MOTOR_X_POUT_RESET                   (D3)

/** Motor Y**/
#define MOTOR_Y_POUT_DIRECTION               (D4)
#define MOTOR_Y_POUT_PULSE                   (D5)
#define MOTOR_Y_PINT_ALARM                   (D6)   // PE_9
#define MOTOR_Y_POUT_RESET                   (D7)

/** Motor Z**/
#define MOTOR_Z_POUT_PU                      (D8)
#define MOTOR_Z_POUT_DR                      (D9)
#define MOTOR_Z_POUT_MF                      (D10)

/** Light Sensor**/ 
#define MOTOR_X_PINT_ZERO                    (PF_2)
#define MOTOR_X_PINT_END                     (PE_6) // ... PF_1 PE_6 
#define MOTOR_Y_PINT_ZERO                    (PE_3) // ... PF_0 PE_3
#define MOTOR_Y_PINT_END                     (PF_7) // ... PD_0 PF_7
#define MOTOR_Z_PINT_ZERO                    (PD_1)
#define MOTOR_Z_PINT_END                     (PG_0) // ...

#endif // _MOTOR_TARGETS_H_
