#include "xyz_sensor_platform.h"
#include "envelopetracker.h"

#define SPI_FREQUENCY 1e6
#define BIG_CHAR_MASK 0x1F
#define BAUD 115200
#define Fs 1e2 // sampling rate -- max: 1kHz

typedef unsigned char byte;
uint8_t* dataToSend;
int sendArrayIndex = 0;
int sendBufferMax = 10000;
Serial pc(SERIAL_TX, SERIAL_RX, BAUD );
DigitalOut led(LED2),led3(LED3);
DigitalOut mag_test(PC_8);
InterruptIn button(USER_BUTTON);
Timeout nextRecord;
XYZSensorPlatform platform;
Envelope *command;
EnvelopeTracker tracker;
byte commandToSend[10]= {'H','O','1','2','3','4','5','6','E',0};
bool isRecording = false;
Envelope* result;
int n = 0;
int getMag = 0;
char magSel = 0;
int recordTime;
bool isEcho = false;
bool isTimeToRecord = false;
bool isMagReset = false;
uint8_t magData[80] = {0};  //80 bytes



void echo(char typ, float x, float y, float z);
uint8_t* echo(char typ, int16_t *p_data, bool isWriteNow = true);
void Rx_interrupt();
void recordTimeup()
{
    isTimeToRecord = true;
}
void released()
{
    led = !led;
    pc.attach(&Rx_interrupt, Serial::RxIrq);
}

int main()
{
    led=1;
    command = new Envelope;
    command->enableHeader(std::string("H"));// 48 H
    command->enableFooter(std::string("E"),8);// 45 E
    command->enableCheckXOR(9);
    tracker.setEnvelope(*command);
    tracker.setBufferLength(100);
    pc.format(8,SerialBase::None,1);
    platform.setSensorSpiFrequency(SPI_FREQUENCY);
// Setup a serial interrupt function to receive data
    pc.attach(&Rx_interrupt, Serial::RxIrq);
    printf("begin....");
    while(1) {
        if(isRecording && n < recordTime && isTimeToRecord) {
            nextRecord.attach(&recordTimeup, 1.0f/(float)Fs);
            isTimeToRecord = false;
            char curMag = 1;
            int16_t mag[NUMBER_OF_MAGNETOMETERS][3] = {0};
            mag_test=!mag_test;
            for(int i = 0; i < NUMBER_OF_MAGNETOMETERS; i++)
            {
                if((curMag & magSel) != 0) platform.get_mag_raw(i, &(mag[i][0]));
                curMag <<= 1;
            }
            curMag = 1;
            int line = 0;
            for(int i = 0; i < NUMBER_OF_MAGNETOMETERS; i++)
            {
                if((curMag & magSel) != 0)
                {
                    memcpy(&magData[line++*10],echo(('M'&BIG_CHAR_MASK)|(i<<5),&mag[i][0],false),10);
                }
                curMag <<= 1;
            }
            if(pc.writeable()) {
                for(int i = 0; i < line*10; i++) pc.putc(magData[i]);
            }
            n++;
            if(isRecording && n == recordTime) {
                nextRecord.detach();
                n = 0;
                isRecording = false;
                int16_t stopCommand[3] = {1<<8,0,0};
                echo('S',stopCommand);
            }
        }// end recording if
        if(getMag>0 && isTimeToRecord) {
            isTimeToRecord = false;
            char curMag = 1;
            int16_t mag[NUMBER_OF_MAGNETOMETERS][3] = {0};
            for(int i = 0; i < NUMBER_OF_MAGNETOMETERS; i++)
            {
                if((curMag & magSel) != 0) platform.get_mag_raw(i, &(mag[i][0]));
                curMag <<= 1;
            }
            curMag = 1;
            int line = 0;
            for(int i = 0; i < NUMBER_OF_MAGNETOMETERS; i++)
            {
                if((curMag & magSel) != 0)
                {
                    memcpy(&magData[line++*10],echo(('M'&BIG_CHAR_MASK)|(i<<5),&mag[i][0],false),10);
                }
                curMag <<= 1;
            }
            if(pc.writeable()) {
                for(int i = 0; i < line*10; i++) pc.putc(magData[i]);
            }
            getMag--;
        }
        if(isMagReset)
        {
            isMagReset = false;
            char curMag = 1;
            for(int i = 0; i < NUMBER_OF_MAGNETOMETERS; i++)
            {
                if((curMag & magSel) != 0) platform.resetMagnetometer(i);
                curMag <<= 1;
            }
        }
    } // end while

}

void echo(char typ,float x, float y, float z)
{
    int16_t p_data[3]= {(int16_t)(x*10), int16_t(y*10), int16_t(z*10)};
    echo(typ,p_data);
}

uint8_t* echo(char typ, int16_t *p_data, bool isWriteNow)
{
    char tmp[] = {typ, p_data[0]>>8, p_data[0], p_data[1]>>8, p_data[1], p_data[2]>>8, p_data[2]};
    command->setEnvelopeData(tmp,7);
    dataToSend = (uint8_t*)(command->getEnvelopeArray());
    if(isWriteNow)
    {
       int i = 0;
       while(!pc.writeable() && i < 10000) i++;
       for(int i = 0; i < 10; i++) pc.putc(dataToSend[i]);
    }
    return dataToSend;
}

void Rx_interrupt()
{
    char c;
    while(pc.readable()) {
        c = pc.getc();
        tracker.parse(&c,1);

        result = tracker.getEnvelope();
        if(result!=NULL) {
            char *dataArray = result->getPayload();
            switch(dataArray[0]) {
                // following alphabets is used
                // I O C X Y Z M R S P N B
                case 'M': // magnet
                    getMag++;
                    magSel = dataArray[1];
                    isTimeToRecord = true;
                    pc.putc('M');
                    break;
                case 'R': // record
                    recordTime = dataArray[1];
                    recordTime *= Fs;
                    if( recordTime == 0 ) recordTime = dataArray[3]*Fs/100;
                    magSel = dataArray[2];
                    isTimeToRecord = true;
                    isRecording = true;
                    break;
                case 'S': // stop
                    isRecording = false;
                    nextRecord.detach();
                    isTimeToRecord = false;
                    break;
                case 'B':
                    magSel = dataArray[1];
                    isMagReset = true;
                    break;
                default:
                    break;
            } // end switch
            result = NULL;
            dataArray = NULL;
        } // end result if
    } // end parsing if
}
