#ifndef __XYZ_SENSOR_PLATFORM_H
#define __XYZ_SENSOR_PLATFORM_H

/*** Includes ----------------------------------------------------------------- ***/
//#include "mbed.h"
#include "mag_ring.h"

/*** Typedefs ----------------------------------------------------------------- ***/
typedef struct {
    int32_t AXIS_X;
    int32_t AXIS_Y;
    int32_t AXIS_Z;
} AxesRaw_TypeDef;

typedef struct {
    AxesRaw_TypeDef Magnetic[NUMBER_OF_MAGNETOMETERS];
} MagneticArray_TypeDef;

class XYZSensorPlatform
{
public:
    XYZSensorPlatform();
    
    MagneticArray_TypeDef get_mag() {
        MagneticArray_TypeDef ret;
        magnetometer->get_m_axes((int32_t *)&ret);
        return ret;
    }
    
    int get_mag_raw(int16_t ret[][3]) {
        return sensor->get_m_axes_raw(ret);
    }
    
    int get_mag_raw(int magIndex, int16_t *ret) {
        return sensor->get_m_axes_raw(magIndex, ret);
    }
    
    void resetMagnetometer(int magIndex)
    {
        sensor->resetMagnetometer(magIndex);
    }
    void setSensorSpiFrequency(int hz){ sensor->setSpiFrequency(hz); }
private:
    MagRing *sensor;
    MagneticSensor *magnetometer;
};
#endif // __XYZ_SENSOR_PLATFORM_H
