/**
  ******************************************************************************
  * @file    mag_ring_targets.h
  * @author  AST / EST
  * @version V0.0.1
  * @date    14-April-2015
  * @brief   This header file is intended to manage the differences between 
  *          the different supported base-boards which might mount the
  *          MAG_RING MEMS Inertial & Environmental Nucleo Expansion Board.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */ 

/* Define to prevent from recursive inclusion --------------------------------*/
#ifndef _MAG_RING_TARGETS_H_
#define _MAG_RING_TARGETS_H_

/*** SPI ***/
/* Use Arduino SPI Connectors */
#define F746ZG_PIN_SPI_MOSI         (SPI_MOSI)      // D11
#define F746ZG_PIN_SPI_MISO         (SPI_MISO)      // D12
#define F746ZG_PIN_SPI_SCLK         (SPI_SCK)       // D13

#define M1_PIN_SPI_CS               (D9)
#define M2_PIN_SPI_CS               (D8)
#define M3_PIN_SPI_CS               (D7)
#define M4_PIN_SPI_CS               (D6)
#define M5_PIN_SPI_CS               (D5)
#define M6_PIN_SPI_CS               (D4)
#define M7_PIN_SPI_CS               (D3)
#define M8_PIN_SPI_CS               (D2)

#define M1_PIN_SPI_CS_1             (PA_12)
#define M2_PIN_SPI_CS_1             (PA_11)
#define M3_PIN_SPI_CS_1             (PB_12)
#define M4_PIN_SPI_CS_1             (PB_11)
#define M5_PIN_SPI_CS_1             (PB_2)
#define M6_PIN_SPI_CS_1             (PB_1)
#define M7_PIN_SPI_CS_1             (PB_15)
#define M8_PIN_SPI_CS_1             (PB_14)

#define NUMBER_OF_MAGNETOMETERS     16

#endif // _MAG_RING_TARGETS_H_

