#include "mbed.h"
#include "mag_ring.h"

MagRing* MagRing::_instance = NULL;

MagRing::MagRing(DevSPI *ext_spi) : dev_spi(ext_spi)
{
//    PinName spiSequence[NUMBER_OF_MAGNETOMETERS] = {
//        M1_PIN_SPI_CS, M2_PIN_SPI_CS, M3_PIN_SPI_CS, M4_PIN_SPI_CS, M5_PIN_SPI_CS, M6_PIN_SPI_CS, M7_PIN_SPI_CS, M8_PIN_SPI_CS,
//        M1_PIN_SPI_CS_1, M2_PIN_SPI_CS_1, M3_PIN_SPI_CS_1, M4_PIN_SPI_CS_1, M5_PIN_SPI_CS_1, M6_PIN_SPI_CS_1, M7_PIN_SPI_CS_1, M8_PIN_SPI_CS_1};
//     PinName spiSequence[NUMBER_OF_MAGNETOMETERS] = {
//         M1_PIN_SPI_CS_1, M2_PIN_SPI_CS_1, M3_PIN_SPI_CS_1, M4_PIN_SPI_CS_1, M5_PIN_SPI_CS_1, M6_PIN_SPI_CS_1, M7_PIN_SPI_CS_1, M8_PIN_SPI_CS_1,
//         M1_PIN_SPI_CS, M2_PIN_SPI_CS, M3_PIN_SPI_CS, M4_PIN_SPI_CS, M5_PIN_SPI_CS, M6_PIN_SPI_CS, M7_PIN_SPI_CS, M8_PIN_SPI_CS};
     PinName spiSequence[NUMBER_OF_MAGNETOMETERS] = {
         M1_PIN_SPI_CS,  M3_PIN_SPI_CS,  M5_PIN_SPI_CS, M7_PIN_SPI_CS,
         M2_PIN_SPI_CS_1, M4_PIN_SPI_CS_1, M6_PIN_SPI_CS_1, M8_PIN_SPI_CS_1,
         M2_PIN_SPI_CS, M4_PIN_SPI_CS, M6_PIN_SPI_CS, M8_PIN_SPI_CS,
         M1_PIN_SPI_CS_1, M3_PIN_SPI_CS_1, M5_PIN_SPI_CS_1, M7_PIN_SPI_CS_1};
    magnetometers = new LIS3MDL* [NUMBER_OF_MAGNETOMETERS];
    for(int i = 0; i < NUMBER_OF_MAGNETOMETERS; i++)
        magnetometers[i] = new LIS3MDL (*dev_spi, (spiSequence[i]));
}

MagRing* MagRing::Instance(DevSPI *ext_spi) {
    if(_instance == NULL) {
        if(ext_spi == NULL)
            ext_spi = new DevSPI(F746ZG_PIN_SPI_MOSI, F746ZG_PIN_SPI_MISO, F746ZG_PIN_SPI_SCLK);

        if(ext_spi != NULL)
            _instance = new MagRing(ext_spi);
    
        if(_instance != NULL) {
            bool ret = _instance->Init();
            if(!ret) {
                error("Failed to init MagRing expansion board!\n");
            }
        }
    }

    return _instance;
}

MagRing* MagRing::Instance(PinName mosi, PinName miso, PinName sclk) {
    if(_instance == NULL) {
        DevSPI *ext_spi = new DevSPI(mosi, miso, sclk);

        if(ext_spi != NULL)
            _instance = new MagRing(ext_spi);
    
        if(_instance != NULL) {
            bool ret = _instance->Init();
            if(!ret) {
                error("Failed to init MagRing expansion board!\n");
            }
        }
    }

    return _instance;
}

bool MagRing::Init_LIS3MDL(void) {
    uint8_t m_id = 0;
    MAGNETO_InitTypeDef InitStructure;
    
    /* Configure sensor */
    InitStructure.M_FullScale = 4.0f;
    InitStructure.M_OperatingMode = LIS3MDL_M_MD_CONTINUOUS;
    InitStructure.M_XYOperativeMode = LIS3MDL_M_OM_UHP;
    InitStructure.M_OutputDataRate = 100.0f;

    dev_spi->frequency(1e2);
    /* Check presence */
    for(int i = 0; i < NUMBER_OF_MAGNETOMETERS; i++){
        if((magnetometers[i]->read_id(&m_id) != MAGNETO_OK) ||
            (m_id != I_AM_LIS3MDL_M))
        {
            printf(" m%d_id: %d, SHOULDBE: %d", i+1, m_id, I_AM_LIS3MDL_M);/*
            for(int j = 0; j < NUMBER_OF_MAGNETOMETERS; j++){
                delete magnetometers[j];
                magnetometers[j] = NULL;
            }
            delete [] magnetometers;
            magnetometers = NULL;
            return true;*/
        }

        if(magnetometers[i]->init(&InitStructure) != MAGNETO_OK)
        {
            printf("%d init fail",i);
            return false;
        }
    }
      
    return true;
}

int MagRing::get_m_axes_raw(int16_t pData[][3])
{
    for(int i = 0; i < NUMBER_OF_MAGNETOMETERS; i++)
    {
        if(magnetometers[i]->get_m_axes_raw((int16_t *)pData[i]) != 0)
        {
            return -1;
        }
    }
    return 0;
}

int MagRing::get_m_axes_raw(int magIndex, int16_t *pData)
{
    return magnetometers[magIndex]->get_m_axes_raw(pData);
}

bool MagRing::resetMagnetometer(int magIndex)
{
    if(magnetometers[magIndex]->resetRegs() != MAGNETO_OK)
    {
        return MAGNETO_ERROR;
    }
    
    uint8_t m_id = 0;
    MAGNETO_InitTypeDef InitStructure;
    
    /* Configure sensor */
    InitStructure.M_FullScale = 4.0f;
    InitStructure.M_OperatingMode = LIS3MDL_M_MD_CONTINUOUS;
    InitStructure.M_XYOperativeMode = LIS3MDL_M_OM_UHP;
    InitStructure.M_OutputDataRate = 100.0f;

    dev_spi->frequency(1e2);
    /* Check presence */
        if((magnetometers[magIndex]->read_id(&m_id) != MAGNETO_OK) ||
            (m_id != I_AM_LIS3MDL_M))
        {
            printf(" m%d_id: %d, SHOULDBE: %d", magIndex+1, m_id, I_AM_LIS3MDL_M);/*
            for(int j = 0; j < NUMBER_OF_MAGNETOMETERS; j++){
                delete magnetometers[j];
                magnetometers[j] = NULL;
            }
            delete [] magnetometers;
            magnetometers = NULL;
            return true;*/
        }

        if(magnetometers[magIndex]->init(&InitStructure) != MAGNETO_OK)
        {
            printf("%d init fail",magIndex);
            return false;
        }
      
    return true;
}
